# Score Targets by Purpose

## UK Universities

| Level | Typical Requirement |
|-------|---------------------|
| Foundation | 5.5 overall, no band below 5.0 |
| Undergraduate | 6.0-6.5 overall, no band below 5.5-6.0 |
| Postgraduate | 6.5-7.0 overall, no band below 6.0-6.5 |
| MBA/Law/Medicine | 7.0-7.5 overall, no band below 6.5-7.0 |

**Examples:**
- Oxford MSc Computer Science: 7.0 overall, 6.5 each
- Imperial MBA: 7.0 overall, 6.5 each
- UCL undergraduate: 6.5 overall, 6.0 each

## Australia Universities

| Level | Typical Requirement |
|-------|---------------------|
| Undergraduate | 6.0-6.5 overall |
| Postgraduate | 6.5-7.0 overall |
| Research degrees | 7.0+ overall |

**Examples:**
- University of Melbourne MSc: 6.5 overall, 6.0 each
- University of Sydney MBA: 7.0 overall, 6.0 each
- UNSW Engineering: 6.5 overall, 6.0 each

## Canada Universities

| Level | Typical Requirement |
|-------|---------------------|
| Undergraduate | 6.0-6.5 overall |
| Postgraduate | 6.5-7.0 overall |
| Top programs | 7.0+ overall |

**Examples:**
- University of Toronto MSc: 7.0 overall, 6.5 each
- UBC MBA: 7.0 overall
- McGill undergraduate: 6.5 overall

## US Universities

Most US universities prefer TOEFL, but accept IELTS:
| Level | Typical Requirement |
|-------|---------------------|
| Undergraduate | 6.5-7.0 overall |
| Graduate | 7.0+ overall |
| Top 20 universities | 7.0-7.5 overall |

## Canada Immigration (Express Entry)

**CLB to IELTS Mapping:**

| CLB | Listening | Reading | Writing | Speaking |
|-----|-----------|---------|---------|----------|
| 10 | 8.5 | 8.0 | 7.5 | 7.5 |
| 9 | 8.0 | 7.0 | 7.0 | 7.0 |
| 8 | 7.5 | 6.5 | 6.5 | 6.5 |
| 7 | 6.0 | 6.0 | 6.0 | 6.0 |
| 6 | 5.5 | 5.0 | 5.5 | 5.5 |
| 5 | 5.0 | 4.0 | 5.0 | 5.0 |

**CRS Points (Express Entry):**
| CLB | First Official Language Points |
|-----|-------------------------------|
| 10+ | 34 per ability (136 max) |
| 9 | 31 per ability (124 max) |
| 8 | 23 per ability (92 max) |
| 7 | 17 per ability (68 max) |

**Key Insight:** CLB 9 in all abilities is a common target for competitive Express Entry scores.

## Australia Immigration (Skilled Migration)

**Points Test (Subclass 189/190):**

| Band | Points |
|------|--------|
| 8.0+ in all | 20 |
| 7.0+ in all | 10 |
| 6.0+ in all | 0 (minimum for eligibility) |

**Key Insight:** 8.0 in all bands gives 20 points — often the difference between invitation and no invitation.

**Competent English (minimum):** 6.0 in each band
**Proficient English:** 7.0 in each band
**Superior English:** 8.0 in each band

## New Zealand Immigration

**Skilled Migrant Category:**
- Overall 6.5+ required for principal applicant
- Or 5.0+ with job offer

## Professional Registration

### Medical (UK - GMC)
- 7.5 overall
- 7.0 in each band
- Applies to: Doctors registering with GMC

### Nursing (UK - NMC)
- 7.0 overall
- 7.0 in Reading
- 7.0 in Writing
- 7.0 in Listening
- 7.0 in Speaking

### Nursing (Australia - AHPRA)
- 7.0 in each band
- Or OET B in each section

### Pharmacy (UK - GPhC)
- 7.0 overall
- 7.0 in each band

### Teaching (Australia)
- 7.5 overall
- 8.0 in Speaking and Listening
- 7.0 in Reading and Writing

## One Skill Retake Strategy

**When to use OSR:**
- One section significantly below others
- That section is dragging overall below target
- Improvement potential is realistic (0.5-1.0 band)

**Example:**
- Current: L7.5 R7.5 W6.0 S7.5 = 7.0 overall
- Target: 7.5 overall for Express Entry CLB 10
- OSR Writing: If W improves to 7.0, overall becomes 7.5

**ROI Calculation:**
- Full retake cost: ~$250-300
- OSR cost: ~$150-200
- If only one section needs work, OSR saves money and stress
