# Study Methods and Practice

## Diagnostic First

Before creating any study plan:

1. **Administer diagnostic** — Full practice test or section-specific assessment
2. **Identify band per section** — Use official score conversion tables
3. **Calculate gaps** — Current vs target for each section
4. **Prioritize by ROI** — Sections with biggest gaps AND most improvement potential

## Section-Specific Practice

### Listening

**Common Issues:**
- Missing answers while reading next question
- Spelling errors on fill-in-the-blank
- Losing place in long recordings

**Practice Methods:**
- Speed drills: Listen at 1.25x, exam feels slower
- Prediction: Read questions first, predict answer types
- Spelling lists: Common academic words with tricky spelling
- Section 4 focus: Academic lectures are hardest, practice most

**Question Type Drills:**
Focus on weakest type in isolation before full tests.

### Reading

**Common Issues:**
- Running out of time (most common)
- True/False/Not Given confusion
- Matching headings taking too long

**Practice Methods:**
- Timed passages: 20 min per passage, strict cutoff
- Skimming drills: Find main idea in 2 minutes
- T/F/NG logic: "Not Given" = information ABSENT, not implied
- Keyword location: Underline, don't re-read

**Time Management:**
- Passage 1: 15 min (easiest)
- Passage 2: 20 min
- Passage 3: 20 min (hardest)
- Buffer: 5 min for transfer/review

### Writing

**Task 1 (Academic) Checklist:**
- [ ] Overview in first paragraph (main trends/features)
- [ ] Key features selected (not everything)
- [ ] Comparisons made (higher, lower, similar)
- [ ] Data cited accurately
- [ ] 150+ words, 20 min max

**Task 1 (General Training) Checklist:**
- [ ] Correct tone (formal/semi-formal/informal)
- [ ] All bullet points addressed
- [ ] Purpose clear in opening
- [ ] Appropriate opening and closing
- [ ] 150+ words, 20 min max

**Task 2 Checklist:**
- [ ] Position stated clearly in introduction
- [ ] Each paragraph = one main idea
- [ ] Examples/evidence support points
- [ ] Conclusion restates position with summary
- [ ] 250+ words, 40 min max

**Band 7 Writing Fixes:**
| Issue | Fix |
|-------|-----|
| "Firstly, Secondly, Thirdly" | Vary: "A key consideration...", "Equally important...", "Furthermore..." |
| Starting paragraphs with "However" | Start with topic sentence, link word can come second |
| Generic examples | Specific: "In Finland, students..." not "In some countries..." |
| Short conclusion | Minimum 2 sentences: restate position + final thought |

### Speaking

**Part 1 (4-5 min):**
- Extend answers: 2-3 sentences per question
- Don't memorize scripts (examiners detect this)
- Practice common topics: home, work, studies, hobbies

**Part 2 (3-4 min):**
- Use the 1 min prep: jot notes on all bullet points
- Structure: opening statement → address each bullet → wrap up
- Aim for full 2 minutes (silence = penalty)
- Practice recording yourself, listen back

**Part 3 (4-5 min):**
- Expect "why" and "how" questions
- Express opinions, then support with reasons
- Speculate: "It's likely that...", "This could be because..."
- Ask for clarification if needed (shows confidence)

**Fluency Killers to Eliminate:**
- "Um", "uh", "like" (fillers)
- Long pauses (>2 sec)
- Repetitive sentence starters ("I think... I think... I think...")
- Self-correction overuse ("No, wait, I mean...")

## Vocabulary Building

**Academic Word List (AWL):**
- 570 word families common in academic texts
- Focus on collocations, not just definitions
- "Conduct research" not "do research"
- "Significant increase" not "big increase"

**Topic Clusters:**
Build vocabulary by IELTS topic:
- Education: curriculum, pedagogy, rote learning, critical thinking
- Environment: sustainability, carbon footprint, renewable, biodiversity
- Technology: innovation, automation, obsolete, cutting-edge
- Health: sedentary, epidemic, preventive, well-being

**Spaced Repetition:**
- Use Anki or similar for daily vocabulary review
- Track words learned and due for review in `~/ielts/vocabulary.md`

## Practice Material Sources

**Official:**
- Cambridge IELTS books (1-19)
- IELTS.org sample tests
- British Council free practice tests

**Supplementary:**
- BBC Learning English
- Academic journals (for reading exposure)
- TED Talks (for listening exposure)

## Study Schedule Framework

**8 Weeks to Exam (2+ band gap):**
| Week | Focus |
|------|-------|
| 1-2 | Diagnostic + weakest section intensive |
| 3-4 | Second weakest section + maintain first |
| 5-6 | Full mock tests + targeted drills |
| 7 | All sections, light practice |
| 8 | Light review, rest before exam |

**4 Weeks to Exam (<1 band gap):**
| Week | Focus |
|------|-------|
| 1-2 | Targeted weakness drills |
| 3 | Full mock tests |
| 4 | Light review, rest |

**Daily Minimum (Busy Professional):**
- 15 min: Vocabulary review
- 15 min: One focused drill (e.g., 5 T/F/NG questions)
- Weekend: 1 full mock test
