# Feedback and Self-Improvement System

## What to Track

### Writing Feedback Patterns

**Task Achievement Issues:**
- [ ] Position unclear
- [ ] Not all parts of question addressed
- [ ] Ideas underdeveloped
- [ ] Examples too generic

**Coherence & Cohesion Issues:**
- [ ] No clear paragraph structure
- [ ] Overuse of linking words ("However", "Moreover")
- [ ] Ideas don't flow logically
- [ ] No overview in Task 1

**Lexical Resource Issues:**
- [ ] Repetitive vocabulary
- [ ] Wrong collocations
- [ ] Spelling errors
- [ ] Inappropriate register

**Grammatical Range & Accuracy Issues:**
- [ ] Only simple sentences
- [ ] Article errors (a/an/the)
- [ ] Tense inconsistency
- [ ] Subject-verb agreement

### Speaking Feedback Patterns

**Fluency Issues:**
- [ ] Too many fillers (um, uh, like)
- [ ] Long pauses (>2 seconds)
- [ ] Self-correction interrupts flow
- [ ] Speaks too fast/slow

**Pronunciation Issues:**
- [ ] Word stress errors
- [ ] Difficult sounds (th, r, l, v/w)
- [ ] Intonation flat
- [ ] Connected speech unclear

**Vocabulary Issues:**
- [ ] Same words repeated
- [ ] Imprecise word choice
- [ ] Lack of idiomatic expressions
- [ ] Can't paraphrase when stuck

**Grammar Issues:**
- [ ] No complex structures
- [ ] Conditional errors
- [ ] Tense mixing
- [ ] Pronoun reference unclear

### Reading/Listening Error Patterns

**Question Type Weaknesses:**
Track accuracy by question type:
```
| Type | Attempts | Correct | % |
|------|----------|---------|---|
| T/F/NG | 50 | 35 | 70% |
| Matching Headings | 30 | 18 | 60% | ← Focus here
| Multiple Choice | 40 | 32 | 80% |
```

**Error Categories:**
- Misread question
- Didn't find answer in text
- Chose distractor
- Time ran out
- Spelling error (Listening)

## Learning from Corrections

### When User Corrects Agent Feedback

If user says "That's not why I lost marks" or similar:
1. Record the correction
2. Adjust future feedback criteria
3. Log in `~/ielts/agent-learning.md`

**Example:**
```markdown
## Agent Learning Log

### 2025-02-13
- **Context:** Marked essay as lacking examples
- **User correction:** "I had examples, they were in paragraph 2"
- **Learning:** Check all paragraphs before claiming missing examples
```

### Pattern Recognition

After 10+ essays:
- Which criteria consistently lowest?
- Which feedback most often disputed?
- What corrections show improvement?

After 5+ mock tests:
- Which sections improving?
- Which question types still weak?
- Is time management improving?

## Progress Milestones

### Band Improvement Thresholds

Track when user crosses band thresholds:
```markdown
## Milestones

- 2025-01-15: Writing first reached 6.0
- 2025-02-01: Writing first reached 6.5
- 2025-02-10: Overall first reached 7.0 (mock)
```

### Ready-to-Test Indicators

**Ready when:**
- 3 consecutive mocks at or above target
- No section more than 0.5 below target in any mock
- Time management stable (finishing with buffer)
- User reports feeling confident

**Not ready when:**
- Mock scores fluctuating widely
- One section consistently below target
- Running out of time regularly
- Anxiety affecting performance

## Feedback Loop Questions

After each major practice session:
1. What felt harder than expected?
2. What felt easier than expected?
3. Any surprises in your answers?
4. What do you want to focus on next?

After each mock test:
1. Did timing feel comfortable?
2. Which section drained you most?
3. Any questions you guessed on?
4. What would you do differently?

## Adaptive Practice

### If User Consistently Struggles

After 3+ failures on same concept:
- Try different explanation
- Break into smaller steps
- Find alternative practice materials
- Suggest targeted resources (video, book, course)

### If User Excels

Move focus to next weakest area:
- Don't over-practice strengths
- Maintain with periodic checks
- Reallocate time to gaps

### If User Plateaus

Signs of plateau:
- Same score across multiple mocks
- Same errors repeating
- Practice without improvement

Intervention strategies:
- Change practice type (drilling → full tests, or vice versa)
- Focus on ONE criterion intensively
- Take a break (burnout affects performance)
- Analyze band descriptors together
