# Gemini Canvas / AI Studio Publish Checklist

Use this checklist after generating CMA outputs.

## Inputs to Provide

- `cma_data.json`
- `cma_report.md` (optional context)
- `gemini_canvas_prompt.md` (copy this prompt first)

## Steps

1. Open [Google AI Studio](https://aistudio.google.com/) or Gemini Canvas.
2. Start a new canvas/project and attach `cma_data.json`.
3. Paste the contents of `gemini_canvas_prompt.md`.
4. Ask for:
   - Responsive layout
   - Sort/filter comparables
   - Value range chart/visual
   - Clear assumptions/disclaimer
5. Iterate once for tone and branding (broker/team logo/colors).
6. Request a hosted or shareable output option.

## Prompt Add-Ons

Use one-line add-ons as needed:

- "Style this for a luxury-listing audience with neutral editorial typography."
- "Add seller objection handling notes under each valuation range."
- "Add a print-friendly report mode."
- "Show comp confidence badges based on distance and data completeness."
