---
name: idfm-journey
description: Query Île-de-France Mobilités (IDFM) PRIM/Navitia for place resolution, journey planning, and disruptions/incident checks. Use when asked to find routes in Île-de-France (e.g., "itinéraire de X à Y"), resolve station/stop ids, or check RER/metro line disruptions, and you have an IDFM PRIM API key.
---

# IDFM Journey (PRIM/Navitia)

Use the bundled script to call PRIM/Navitia endpoints without extra dependencies.

## Prereqs

- Set `IDFM_PRIM_API_KEY` in the environment before running.

## Quick commands

Run from anywhere (path is inside the skill folder):

- Resolve places (best match + list):
  - `python3 scripts/idfm.py places "Ivry-sur-Seine" --count 5`

- Journeys (free-text from/to; resolves place ids first):
  - `python3 scripts/idfm.py journeys --from "Ivry-sur-Seine" --to "Boulainvilliers" --count 3`

- Incidents / disruptions (by line id or filter):
  - `python3 scripts/idfm.py incidents --line-id line:IDFM:C01727`
  - `python3 scripts/idfm.py incidents --filter 'disruption.status=active'`

Add `--json` to print raw API output.

## Notes

- If place resolution is ambiguous, increase `--count` and choose the right `stop_area` id.
- For API details and examples, read: `references/idfm-prim.md`.
