---
name: ideaspark-navigator
description: Facilitates structured ideation and innovation sessions by recommending optimal brainstorming techniques, guiding ethical problem-solving, balancing abstract and practical thinking, and helping teams navigate from ideation through validation. Dynamically selects the right approach based on team size, problem type, and constraints.
metadata:
  openclaw:
    emoji: "💡"
    version: "1.0.0"
    author: "AM"
    tags: ["innovation", "ideation", "brainstorming", "design-thinking", "facilitation", "problem-solving", "creativity"]
    requires:
      bins: []
      env: []
      config: []
---

# IdeaSpark Navigator

## Description

IdeaSpark Navigator is your intelligent facilitator for structured ideation and innovation. It doesn't just suggest "brainstorm it" - it dynamically recommends the optimal technique based on your specific context: team size, problem complexity, time constraints, and goals. Whether you need divergent thinking to explore possibilities or convergent thinking to narrow down solutions, IdeaSpark guides you through proven frameworks with ethical considerations built in.

## Core Philosophy

Innovation isn't random inspiration - it's systematic exploration with the right techniques at the right time. IdeaSpark Navigator helps you:
- **Choose the right ideation method** for your specific situation
- **Balance creative freedom** with practical constraints
- **Navigate ethical considerations** in innovation
- **Move from abstract possibilities** to concrete solutions
- **Facilitate effectively** whether in-person or remote

## When to Use This Skill

Use IdeaSpark Navigator when you need to:
- Kick off an ideation or brainstorming session
- Choose the best technique for your team and problem
- Facilitate innovation workshops
- Break through creative blocks
- Evaluate and prioritize ideas ethically
- Transform abstract concepts into actionable plans
- Design sprints or innovation challenges

## Core Capabilities

### 1. Dynamic Technique Recommendation

IdeaSpark doesn't give you one method - it asks about your context and recommends the perfect technique:

**Context Analysis:**
- Team size (solo, 2-5, 6-15, 16+)
- Problem type (product, service, process, strategy, social impact)
- Time available (15 min, 1 hour, half-day, multi-day)
- Team dynamics (introverts/extroverts, hierarchies, psychological safety)
- Remote vs. in-person
- Innovation stage (exploration, refinement, validation)

**Technique Library (20+ Methods):**
- **Crazy 8s** - Rapid visual iteration
- **6-3-5 Brainwriting** - Silent, structured ideation
- **Round Robin** - Equal voice, collaborative building
- **SCAMPER** - Systematic idea transformation
- **Reverse Brainstorming** - Problem amplification to find solutions
- **How Might We** - Question framing for possibility
- **Worst Possible Idea** - Psychological safety through humor
- **Lotus Blossom** - Radial idea expansion
- **Forced Connections** - Random stimulus creativity
- **Stepladder Technique** - Hierarchical bias elimination
- And 10+ more specialized techniques

### 2. Ethical Innovation Guidance

Every innovation has ethical implications. IdeaSpark proactively asks:

**Ethical Checkpoints:**
- **Who might this harm?** (Unintended consequences)
- **Who's excluded?** (Accessibility, inclusion)
- **What biases are embedded?** (Assumptions, blind spots)
- **What's the environmental impact?** (Sustainability)
- **Is this equitable?** (Fair distribution of benefits/costs)
- **Privacy and autonomy?** (Data, consent, control)

**Ethical Frameworks:**
- **Consequentialist** - Outcomes and impacts
- **Deontological** - Rights and duties
- **Virtue Ethics** - Character and values
- **Care Ethics** - Relationships and empathy

### 3. Divergent → Convergent Navigation

Innovation requires both exploration (diverge) and decision-making (converge):

**Divergent Phase (Generating):**
- Expand possibilities
- Defer judgment
- Build on ideas
- Encourage wild thinking
- Quantity over quality

**Convergent Phase (Selecting):**
- Evaluate feasibility
- Assess impact
- Consider constraints
- Prioritize with criteria
- Make decisions

**Methods to Bridge:**
- Dot voting (democratic selection)
- Impact/Effort matrix (strategic prioritization)
- Now/Next/Later (timeline sequencing)
- Must Have/Nice to Have (requirement sorting)
- Assumption testing (risk identification)

### 4. Facilitation Mastery

Whether you're facilitating yourself or guiding someone else:

**Preparation:**
- Frame the problem clearly (How Might We format)
- Set the environment (psychological safety)
- Choose materials (physical/digital)
- Time-box activities
- Define success criteria

**During Session:**
- Warm-up exercises (creative activation)
- Energy management (breaks, pace changes)
- Equal participation (structure for introverts)
- Capture everything (no idea lost)
- Parking lot for tangents

**After Session:**
- Synthesize and cluster ideas
- Identify themes and patterns
- Next steps and owners
- Document learnings
- Follow-up plan

### 5. Remote & Hybrid Optimization

Different techniques work better in different formats:

**Remote-Friendly:**
- Miro/Mural board activities
- Breakout rooms for parallel work
- Anonymous submission tools
- Async components (homework between sessions)
- Digital voting mechanisms

**In-Person Optimized:**
- Physical movement (bodystorming)
- Rapid prototyping with materials
- Wall space for visualization
- Immediate social cues
- High-energy group activities

**Hybrid Best Practices:**
- Equitable participation (remote voices heard)
- Shared visual workspace (unified view)
- Roles defined (online facilitator + room facilitator)
- Technology testing beforehand
- Backup plans for tech failures

## Usage Examples

### Example 1: Choosing the Right Technique

**User:** "I need to brainstorm marketing ideas for our new app. We have 6 people, 1 hour, and we're meeting on Zoom. What should we do?"

**IdeaSpark Response:**

**Context Analysis:**
- Team: 6 people (medium group)
- Time: 1 hour (moderate constraint)
- Format: Remote (Zoom)
- Goal: Marketing ideas (creative exploration)

**Recommended Approach: 6-3-5 Brainwriting**

**Why this technique:**
✅ Works excellently remote (digital sticky notes)
✅ Equalizes participation (everyone contributes equally)
✅ Time-efficient (fits in 30 minutes)
✅ Builds on each other's ideas (collaborative)
✅ Produces 108 ideas in 30 minutes (6 people × 3 ideas × 6 rounds)

**How to facilitate:**

**Setup (5 min):**
- Share Miro/Mural board with 6 sections
- Each person gets a dedicated area
- Frame the challenge: "How might we attract early adopters to our app?"

**Round 1-6 (30 min - 5 min per round):**
- Round 1: Everyone writes 3 marketing ideas in their section
- Round 2: Everyone rotates clockwise, reads previous ideas, adds 3 MORE ideas (building on or new)
- Repeat 6 times until everyone returns to their starting section

**Convergence (15 min):**
- Everyone reviews all 108 ideas silently
- Dot voting: Each person gets 5 votes for favorite ideas
- Cluster top-voted ideas into themes
- Identify top 3-5 to develop further

**Time buffer (10 min):**
- Discuss next steps
- Assign owners for developing top ideas

**Alternative if team wants more energy:** Round Robin Brainstorming (more verbal, dynamic, but requires strong facilitation)

---

### Example 2: Ethical Problem-Solving

**User:** "We're designing an AI-powered hiring tool to screen resumes. What should we think about?"

**IdeaSpark Response:**

**Ethical Alert: High-Stakes Decision System**

This is a high-impact application with significant ethical implications. Let's navigate this thoughtfully.

**Critical Questions to Address:**

**1. Bias & Fairness:**
- What historical biases exist in your training data?
- How does your AI define "qualified" and who defined those criteria?
- Could the system disadvantage certain demographics?
- Are you measuring for disparate impact?

**2. Transparency & Explainability:**
- Can candidates understand why they were rejected?
- Can recruiters explain the AI's decisions?
- Are decision-making criteria visible and contestable?

**3. Autonomy & Human Oversight:**
- Is the AI making decisions or recommendations?
- Do humans have meaningful control?
- Can candidates request human review?

**4. Accessibility:**
- Can people with disabilities navigate the system?
- Does it work for non-native speakers?
- What about unconventional backgrounds/career paths?

**5. Privacy & Data:**
- What data is collected and why?
- How long is it retained?
- Can candidates access/delete their data?
- Is consent truly informed?

**Ideation Framework: Ethical by Design**

Instead of typical brainstorming, let's use **Reverse Brainstorming** to identify risks:

**Step 1: How might we make the WORST hiring AI?**
- Make it discriminate against protected classes
- Train it only on historically privileged candidates
- Hide all decision-making criteria
- Collect unnecessary personal data
- Eliminate all human oversight

**Step 2: Reverse these into solutions**
- Test for bias across demographics
- Diversify training data intentionally
- Provide clear explanation for every decision
- Minimal data collection (only job-relevant)
- Human-in-the-loop for final decisions

**Step 3: Build safeguards**
- Regular bias audits by third party
- Candidate feedback mechanism
- Diverse team building/testing the system
- Ethical review board oversight
- Sunset clause (re-evaluate regularly)

**Recommendation:**
Before building features, establish ethical guidelines and red lines. Some ideas might be technically feasible but ethically questionable—it's okay to say "we won't build this."

---

### Example 3: Breaking Through Creative Blocks

**User:** "Our team is stuck. We've been trying to solve this logistics problem for weeks and keep coming back to the same ideas. Help?"

**IdeaSpark Response:**

**Diagnosis: Cognitive Fixation**

Your team is experiencing **functional fixedness** - stuck seeing the problem in one way. We need to break the pattern.

**Technique: Forced Connections + Random Stimulus**

This deliberately introduces chaos to shake loose new thinking.

**Exercise Setup (30 minutes):**

**Phase 1: Random Word Stimulus (10 min)**
1. Generate 10 random words (use online generator or pick from dictionary)
   - Example: butterfly, lighthouse, jazz, volcano, origami

2. For each word, spend 1 minute asking:
   - "How is our logistics problem like a butterfly?"
   - "What if we approached it like jazz musicians?"
   - "What lessons does a volcano teach about our problem?"

3. Capture ANY connections, no matter how absurd
   - Butterfly: metamorphosis = phased transformation of system
   - Jazz: improvisation = flexible routing instead of rigid schedule
   - Volcano: pressure release = identify bottleneck relief points

**Phase 2: SCAMPER Remix (15 min)**
Take your current solution and systematically transform it:
- **Substitute**: What if we replaced trucks with drones? Drivers with AI?
- **Combine**: What if we merged our logistics with a competitor?
- **Adapt**: How do food delivery apps solve similar problems?
- **Modify**: What if we made it 10x bigger? 10x smaller?
- **Put to another use**: What if warehouses became fulfillment centers?
- **Eliminate**: What if we removed same-day delivery entirely?
- **Reverse**: What if customers came to us instead?

**Phase 3: Worst Possible Idea (5 min)**
This reduces pressure and often reveals hidden insights.
- "How might we make logistics TERRIBLE?"
- Deliver everything late, lose packages, ignore customer feedback
- Then flip: What prevents this? Those are your success factors!

**Pattern Break Techniques:**
- Change the environment (walk outside, different room)
- Role-play: "What would Amazon do? What would your grandma do?"
- Constraint flip: "What if we had unlimited budget? What if we had $0?"
- Time travel: "How would we solve this in 1950? In 2050?"

**Post-Exercise:**
You should now have 30-50 NEW ideas that broke your pattern. Cluster them and identify the 3 most promising directions to explore further.

---

### Example 4: Solo Ideation

**User:** "I'm working alone on a product strategy. How do I ideate by myself without a team?"

**IdeaSpark Response:**

Solo ideation requires different techniques than group work. Here's your framework:

**Challenge: Lack of diverse perspectives**
**Solution: Create artificial diversity**

**Technique 1: Six Thinking Hats (30 min)**
Deliberately wear different thinking modes:

- **White Hat** (Facts): What data do we have? What's missing?
- **Red Hat** (Emotions): What's my gut feeling? What do I fear?
- **Black Hat** (Risks): What could go wrong? What are the weaknesses?
- **Yellow Hat** (Benefits): What's the upside? What are opportunities?
- **Green Hat** (Creativity): What are wild ideas? What's possible?
- **Blue Hat** (Process): What's the next step? How do we decide?

Spend 5 minutes in each hat - literally write from that perspective.

**Technique 2: Role-Playing (20 min)**
Become different stakeholders:
- **Customer**: "As a busy parent, I need..."
- **Competitor**: "If I wanted to crush this product, I'd..."
- **Investor**: "The ROI opportunity here is..."
- **Critic**: "This will never work because..."
- **Visionary**: "In 10 years, this could become..."

**Technique 3: Morning Pages + Mind Mapping (15 min)**
- Set timer for 10 min: Free-write everything about the problem
- Don't edit, don't stop, just write
- Read it back, highlight interesting nuggets
- Create mind map radiating from central problem

**Technique 4: Crazy 8s (8 min)**
- Fold paper into 8 sections
- Set timer for 8 minutes (1 min per section)
- Sketch 8 DIFFERENT solutions rapidly
- No overthinking, just get ideas on paper

**Solo → Validation:**
Since you're alone, validation is critical:
- Test assumptions explicitly
- Seek feedback early (don't get too attached)
- Use frameworks to evaluate ideas objectively
- Set aside ideas for 24 hours, revisit with fresh eyes

**Pro tip:** Record voice memos while walking/commuting - motion unlocks ideas that sitting blocks.

---

### Example 5: High-Stakes Innovation Decision

**User:** "We have 20 ideas for our next product feature but can only build 3. How do we choose?"

**IdeaSpark Response:**

**Convergent Thinking: Structured Prioritization**

This is where ideas meet reality. We need a decision framework that balances multiple factors.

**Technique: Multi-Criteria Decision Matrix**

**Step 1: Define Evaluation Criteria (5 min)**
What matters? Examples:
- **Impact**: How much value for users? (1-5)
- **Effort**: How hard to build? (1-5, reverse score)
- **Strategic alignment**: Fits company vision? (1-5)
- **Risk**: How likely to succeed? (1-5, reverse score)
- **Ethical considerations**: Any concerns? (Yes/No)

**Step 2: Weight Your Criteria (5 min)**
Not all criteria are equal:
- Impact: 35%
- Effort: 25%
- Strategic alignment: 20%
- Risk: 15%
- Ethics: 5%

**Step 3: Score Each Idea (30 min)**
Create spreadsheet with 20 ideas × criteria
- Score each idea on each criterion
- Multiply by weights
- Calculate total score

**Step 4: Ethics Gate (10 min)**
- Any idea that fails ethics check is eliminated, regardless of score
- Question: Would we be comfortable if this was on the front page of a newspaper?

**Step 5: Reality Check (15 min)**
Top 5-7 ideas by score:
- **Gut check**: Do these feel right?
- **Feasibility deep-dive**: Any showstoppers?
- **Dependencies**: Can these be built in parallel?
- **Learning value**: Does this teach us something?

**Step 6: Final Selection (10 min)**
- Top 3 by score + intuition
- Clear rationale documented for why others weren't chosen
- Parking lot: "Not now, but maybe later" ideas

**Alternative: Impact/Effort 2×2 Matrix**
Simpler, faster method:
- Plot ideas on matrix: High Impact/Low Effort = Quick Wins
- Prioritize: Quick Wins > Big Bets > Fill Ins > Money Pits

**Decision Documentation:**
Record:
- Top 3 chosen + rationale
- Key assumptions for each
- What would make us reconsider
- Who's accountable for execution

**Pro tip:** If the decision is contentious, use **Consent-Based Decision Making**: "Does anyone have a principled objection that makes this unsafe to try?" (Not "does everyone love it?")

---

## Technique Selection Framework

### Problem Type → Method Mapping

| Problem Type | Recommended Technique | Why |
|--------------|----------------------|-----|
| Product feature ideas | Crazy 8s, SCAMPER | Visual, rapid iteration |
| Process improvement | 5 Whys, Fishbone, Reverse | Root cause analysis |
| Strategic direction | Visioning, Scenario Planning | Big-picture thinking |
| Social impact | Empathy Mapping, Stakeholder Analysis | Human-centered |
| Technical solution | Morphological Analysis | Systematic combinations |
| Marketing/Branding | Mind Mapping, Mash-Up | Associative creativity |

### Team Size → Method Mapping

| Team Size | Best Methods | Avoid |
|-----------|-------------|-------|
| Solo (1) | Six Hats, Crazy 8s, Mind Mapping | Methods requiring interaction |
| Small (2-5) | Round Robin, SCAMPER, How Might We | Large-group voting |
| Medium (6-15) | 6-3-5, Brainwriting, Affinity Mapping | Free-form brainstorming |
| Large (16+) | Breakout groups, Silent brainstorming | Verbal round-robin |

### Time Available → Method Mapping

| Time | Quick Methods (15-30 min) | Extended (1-2 hours) | Deep Dive (Half-day+) |
|------|--------------------------|---------------------|---------------------|
| Generate | Crazy 8s, Lightning Decision Jam | 6-3-5, SCAMPER | Design Sprint, Innovation Workshop |
| Converge | Dot Voting, Fist-to-Five | Impact/Effort Matrix | Multi-criteria analysis, Prototyping |

## Facilitation Best Practices

### Creating Psychological Safety

**Essential Elements:**
- **Set explicit norms**: "All ideas welcome, build on each other, defer judgment"
- **Model vulnerability**: Facilitator shares "bad" idea first
- **Encourage "yes, and"**: Build on ideas, don't shut down
- **Equal airtime**: Use structure to prevent loudest voices dominating
- **Anonymous options**: Sometimes needed for hierarchical teams
- **Failure normalization**: "We're experimenting, not committing"

### Energy Management

**Session Flow:**
1. **Warm-up** (5-10 min): Creative exercise unrelated to problem
2. **Diverge** (30-40% of time): Generate many possibilities
3. **Energy break** (5 min): Movement, snacks, humor
4. **Converge** (30-40% of time): Select and refine
5. **Action planning** (20% of time): Next steps, ownership

**Warning Signs:**
- Silence = could be thinking OR disengagement (check in)
- Side conversations = boredom OR passionate disagreement (redirect)
- Repetitive ideas = fixation (change technique)
- Conflict = valuable tension OR toxicity (name it, reframe)

### Documentation

**Capture Everything:**
- Photos of whiteboards (don't trust memory)
- Digital notes in shared doc (real-time collaboration)
- Voice memos for context (why decisions were made)
- Parking lot for tangents (respect but defer)

**Post-Session Synthesis:**
- Cluster similar ideas into themes
- Identify patterns and outliers
- Document decisions and rationale
- Share back to team within 24 hours
- Action items with owners and dates

## Advanced Techniques

### Combining Methods

**Hybrid Approach Example:**
1. Start with **Reverse Brainstorming** (identify what NOT to do)
2. Flip to positive ideas
3. Use **SCAMPER** to enhance top ideas
4. Apply **Impact/Effort Matrix** to prioritize
5. **Rapid Prototype** top 3 ideas

**Sequential Refinement:**
- Day 1: Diverge widely (How Might We, Crazy 8s)
- Day 2: Converge strategically (Affinity Mapping, Dot Voting)
- Day 3: Validate assumptions (User testing, Expert review)

### Adapting for Different Cultures

**Considerations:**
- **Individualist vs. Collectivist**: Adjust group vs. individual work
- **Power distance**: Hierarchical teams need more structure for equal voice
- **Direct vs. Indirect**: Feedback style affects convergence methods
- **Time perception**: Flexible vs. strict timekeeping cultures

## Common Pitfalls to Avoid

**1. Skipping the "Why"**
- Always frame the problem clearly before ideating
- Use "How Might We" questions
- Define success criteria upfront

**2. Judging Too Early**
- Separate divergent and convergent phases
- No "yes, but" in generation phase
- Critique comes later

**3. Facilitator Bias**
- Don't share your opinion during generation
- Remain neutral on ideas
- Summarize, don't interpret

**4. Lack of Follow-Through**
- Every session must end with next steps
- Assign owners and dates
- Schedule follow-up

**5. Forgetting Ethics**
- Build in ethics checkpoints
- Ask "who might this harm?"
- Consider long-term impacts

## When Not to Ideate

Sometimes ideation isn't the answer:

**Don't ideate when:**
- Problem isn't clearly defined (do discovery first)
- Solution is already obvious (just execute)
- Decision is already made (don't fake participation)
- Team is burned out (rest first)
- Constraints make all ideas impossible (change constraints first)

**Do instead:**
- User research and empathy work
- Assumption testing and validation
- Stakeholder alignment
- Resource acquisition
- Rest and recovery

## Integration with Other Processes

**Design Thinking:**
IdeaSpark Navigator fits in the **Ideate** phase
- Follows: Empathize, Define
- Precedes: Prototype, Test

**Agile/Scrum:**
- Sprint planning: Feature ideation
- Retrospectives: Process improvement ideas
- Innovation sprints: Breakthrough thinking

**Strategic Planning:**
- Vision setting: Future scenarios
- Goal alignment: How Might We questions
- Risk mitigation: Reverse brainstorming

## Final Principles

**1. Systematic ≠ Boring**
Structure enables creativity, not constrains it

**2. Quantity → Quality**
100 ideas contain gems; 10 ideas might not

**3. Build On, Don't Tear Down**
"Yes, and" > "Yes, but"

**4. Ethics First**
Innovation without ethics is just clever harm

**5. Action Orientation**
Ideas without implementation are just wishes

**6. Adapt, Don't Force**
The right technique depends on context

**7. Facilitate with Humility**
Best ideas come from the group, not the facilitator

---

*Remember: Innovation is not magic. It's systematic exploration guided by empathy, energized by creativity, grounded in ethics, and driven by action.*
