# 想法验证 — 七步流程详细指南

## 核心原则

1. **交互式咨询，非一次性报告**：每步输出阶段文档，等用户确认后再推进
2. **反向提问与厘清**：主动追问关键细节，帮助用户理清思路
3. **不做简单否定**：若不可行，基于调研提出有差异化的替代方案
4. **主动调研**：使用 `web_search` 和 `agent-browser` 搜索实时数据
5. **阶段性退出**：用户可在任何阶段放弃或转向

## 步骤 1：想法澄清（Idea Clarification）

**目标**：把模糊想法变成清晰的产品概念。

**执行**：
1. **优先检查**：如果项目目录中存在 `idea-brief.md`（阶段一生成的灵感确认文档），先读取该文件，将其中的用户偏好、经验、顾虑等作为已知上下文，跳过已确认的信息，只追问仍不清晰的部分
2. 如果没有灵感确认文档，请用户一句话描述想法
3. 反向提问厘清：具体痛点、目标用户画像、现有替代方案、核心差异、时机判断
4. 追问不清晰的地方

**输出模板**：
```
## 步骤 1：想法澄清
### 想法概述
### 核心问题/痛点
### 目标用户画像
### 现有替代方案
### 核心差异化
### 时机判断
### 待确认事项
```

## 步骤 2：市场调研（Market Research）

**目标**：搜索分析竞品与市场格局。

**执行**：
1. 读取 `references/find-ideas.md` 中的搜索关键词模板（竞品搜索部分）
2. 使用 `web_search` 搜索直接竞品、间接竞品、新兴趋势
3. 使用 `agent-browser` 深入调研竞品官网、定价、用户评价
4. 分析市场空白点
5. 估算 TAM/SAM/SOM

**搜索关键词参考**：
```
[产品关键词] alternatives / competitors / vs
best [产品类别] tools 2025 2026
site:producthunt.com [关键词]
site:alternativeto.net [关键词]
[产品关键词] 替代品 / 竞品 / 推荐
```

**输出模板**：
```
## 步骤 2：市场调研
### 竞品分析
| 竞品名称 | 类型 | 核心功能 | 定价 | 优势 | 劣势 | 用户评价 |
### 市场格局
### 市场空白点
### 市场规模估算（TAM/SAM/SOM）
### 关键发现
### 初步判断
```

**方向转换**：如果市场已被充分覆盖或存在明显障碍：
- 分析竞品薄弱环节，提出 2-3 个差异化替代方向
- 如果是根本性障碍（低频、天花板低），触发 **Idea 扩展机制**（读取 `references/idea-expansion.md`）

## 步骤 3：需求验证（Demand Validation）

**目标**：验证目标用户是否真有需求，以及需求强度。

**执行**：
1. 使用 `web_search` 搜索社区讨论（Reddit、HN、V2EX、知乎）
2. 使用 `agent-browser` 浏览具体帖子，提取用户原话
3. 评估需求紧迫度和付费意愿

**搜索关键词参考**：
```
site:reddit.com "[痛点关键词]" / "looking for" [类别] / "recommend" [类别]
site:news.ycombinator.com "Show HN" / "Ask HN" [关键词]
site:v2ex.com [关键词]
site:zhihu.com "有没有" / "推荐" [类别]
[竞品名] review / complaints / "I wish"
```

**输出模板**：
```
## 步骤 3：需求验证
### 社区讨论分析
### 用户痛点提取（附来源链接）
### 搜索趋势
### 需求强度评估（紧迫度/频率/付费意愿）
### 关键发现
```

## 步骤 4：技术可行性评估（Technical Feasibility）

**目标**：评估技术难度和资源需求。

**执行**：
1. 分析核心功能所需技术栈
2. 评估技术成熟度
3. 估算 MVP 开发周期
4. 识别技术风险
5. 判断个人/小团队能否完成

**输出模板**：
```
## 步骤 4：技术可行性
### 推荐技术栈
### MVP 功能范围（核心 + 可延后）
### 开发周期估算（MVP / V1）
### 技术风险（风险项/严重程度/应对方案）
### 资源需求（人力/基础设施/预估成本）
### 可行性判断
```

## 步骤 5：商业模式分析（Business Model）

**目标**：设计可行的商业模式和增长路径。

**执行**：
1. 参考 `references/evaluation-framework.md` 中的盈利模式和获客渠道
2. 分析盈利模式
3. 设计获客策略
4. 估算 CAC/LTV
5. 构建成本结构

**输出模板**：
```
## 步骤 5：商业模式
### 推荐盈利模式
### 获客策略（渠道/CAC/优先级）
### 用户增长路径
### 单位经济模型（CAC/LTV/比值/回收期）
### 成本结构
### 盈亏平衡估算
```

## 步骤 6：风险评估（Risk Assessment）

**目标**：全面识别风险并制定应对策略。

**执行**：
1. 识别四类风险：市场、技术、竞争、法律/合规
2. 评估概率和影响
3. 制定应对策略
4. 识别致命风险

**输出模板**：
```
## 步骤 6：风险评估
### 风险矩阵（风险项/类别/概率/影响/风险等级/应对策略）
### 致命风险
### 风险缓解优先级
```

## 步骤 7：综合评分与最终建议（Final Verdict）

**目标**：汇总所有分析，给出最终评估。

**执行**：
1. 按 `references/evaluation-framework.md` 的评分标准对五个维度评分
2. 根据综合评分解读规则给出建议
3. 按 `references/report-template.md` 生成完整报告
4. 如果推荐推进，设计最小验证方案

**输出模板**：
```
## 步骤 7：综合评估
### 评分卡（市场需求度/竞争优势/技术可行性/商业潜力/投入产出比）
### 最终建议（🟢全力投入 / 🟡做MVP验证 / 🟠调整方向 / 🔴不建议投入）
### 下一步行动计划
#### 最小验证方案（核心假设/验证方式/时间框架/成功标准）
#### 90 天行动路线图
```

## agent-browser 调研目标清单

使用 `agent-browser` 时优先访问：

**竞品调研**：竞品官网首页、定价页、功能列表页、changelog

**用户评价平台**：Product Hunt、G2/Capterra、App Store/Google Play、GitHub（star/issue 活跃度）

**社区论坛**：Reddit 相关 subreddit、Hacker News、IndieHackers、V2EX
