# Idea 扩展与延伸方法论

当原始想法存在根本性障碍时，用本文档的方法系统性地扩展和延伸 idea。

## 触发条件（满足任一即触发）

- 使用频率过低，难以支撑留存和商业化
- 核心差异化在实际体验中被削弱
- 市场天花板明显过低
- 用户主动希望探索替代方向

## 核心思路

不局限于具体应用场景，而是提炼**底层模式**（核心交互范式 + 技术能力），将该模式迁移到更高频、更有商业潜力的场景。

## 六步执行

### 第一步：提炼底层模式

从原始 idea 中抽象出核心技术/交互模式，关注三个维度：
- **输入方式**：拍照、语音、视频、文字、扫码等
- **AI 处理能力**：识别、分类、索引、推荐、估值等
- **输出价值**：快速检索、决策辅助、自动化管理等

**示例**：
- "拍照记录物品位置" → "多模态 AI 自动录入 + 语义索引 + 模糊搜索"
- "语音记录会议内容" → "语音实时转结构化数据 + 智能检索"

### 第二步：问题诊断表

| 问题维度 | 原始 idea 的表现 | 理想状态 |
|---------|-----------------|---------|
| 使用频率 | [如：低频] | 高频（至少每周） |
| AI 准确度 | [如：识别不稳定] | 高准确率 |
| 付费意愿 | [如：痛点不够强] | 明确付费动力 |
| 市场规模 | [如：小众需求] | 足够大的可服务市场 |

### 第三步：场景迁移搜索

使用 `web_search`，基于底层模式搜索其他场景的应用：

```
# 技术模式迁移
"[核心技术能力] app" [高频场景关键词]
"[核心技术能力]" startup idea 2025 2026
"AI [输入方式]" "[输出价值]" app market

# 相邻市场
"[原始场景] alternative use case"
"[底层技术]" "high frequency" app idea

# 成功案例
"[类似技术模式的知名产品]" "similar to" OR "alternative"
"[类似技术模式]" startup funding raised
```

### 第四步：生成替代 idea

提出 2-4 个替代方向，每个包含：
1. 一句话描述
2. 与原始 idea 的关系（保留了什么，改变了什么）
3. 为什么更好（逐项对比问题诊断表）
4. 市场验证信号（竞品、社区讨论、市场数据）
5. 风险提示

**筛选标准**（优先满足更多条件的方向）：
- 使用频率显著更高
- AI 准确率更高（数据更标准化）
- 有市场验证信号
- 技术栈高度复用
- 商业化路径更清晰

### 第五步：对比输出

| 维度 | 原始 idea | 替代 A | 替代 B | 替代 C |
|------|----------|--------|--------|--------|
| 使用频率 | | | | |
| AI 准确度 | | | | |
| 付费意愿 | | | | |
| 市场规模 | | | | |
| 技术复用度 | 基准 | | | |
| 竞争格局 | | | | |

### 第六步：给出推荐

- 明确推荐最看好的 1 个方向并给出理由
- 理由回扣问题诊断表
- 尊重用户选择

## 输出后流程

- **选择替代方向**：从步骤 1 重新开始（可复用已有调研）
- **继续原方向**：尊重决定，继续推进
- **融合多个方向**：协助整合新概念，重新评估
