# 前端设计规范

本文档定义 MVP 阶段三中前端界面的设计标准。目标：产出有辨识度、生产级质量的界面，避免千篇一律的 AI 生成风格。

## 设计思考流程

编码前先明确方向：

1. **目的**：这个界面解决什么问题？谁在用？
2. **调性**：选定一个明确的美学方向（极简、复古未来、自然有机、精致奢华、趣味玩具感、杂志编辑风、粗野主义、装饰艺术、柔和粉彩、工业实用等），并贯彻执行
3. **约束**：技术栈、性能、无障碍等硬性要求
4. **记忆点**：用户看完后会记住什么？找到那个让界面与众不同的关键元素

**核心原则**：选定一个清晰的概念方向，精准执行。大胆的极繁和克制的极简都可以——关键是设计意图明确，而非随意堆砌。

## 视觉规范

### 字体

- 选择有个性、有辨识度的字体，**禁止使用** Arial、Inter、Roboto、系统默认字体等泛用字体
- 标题字体与正文字体搭配：一个有张力的展示字体 + 一个精致的阅读字体
- 每次设计使用不同的字体组合，避免反复收敛到相同选择

### 色彩与主题

- 建立统一的色彩系统，使用 CSS 变量保持一致性
- 用主色+锐利的点缀色，而非平均分配的温吞配色
- **禁止**：紫色渐变+白底等典型 AI 生成配色
- 在浅色/深色主题间做有意识的选择，而非默认浅色

### 动效与交互

- 用动画增加体验层次和微交互反馈
- HTML 项目优先使用纯 CSS 动画；React 项目可使用 Motion 库
- 聚焦高影响力时刻：精心编排的页面加载 + 错落的渐入（animation-delay）比零散的微交互更有效
- 善用滚动触发和悬停状态制造惊喜

### 空间构图

- 打破常规布局：不对称、重叠、对角线流动、突破网格的元素
- 要么大方留白，要么有控制地高密度排布——避免不上不下的中庸布局

### 背景与视觉细节

- 营造氛围和纵深感，不要默认纯色背景
- 根据整体美学方向选择合适的纹理和效果：渐变网格、噪点纹理、几何图案、透明叠层、戏剧性阴影、装饰边框、自定义光标、颗粒感覆盖等

## 实现原则

- 代码必须是可运行的、生产级的，不是示意图
- 实现复杂度匹配设计意图：极繁风格需要丰富的动画和细节代码；极简风格需要克制、精准，在间距/字体/微妙细节上下功夫
- 每次设计都应是独特的——不同的主题、字体、美学风格，不要跨项目复制同一套视觉语言
