# MVP 实现指南

## 核心原则

1. **最小化**：只实现验证核心假设所需的最少功能，砍掉一切非必要的
2. **快速迭代**：先跑通核心流程，再优化细节
3. **用户可用**：MVP 必须是可运行、可交互的，不是 demo 或 mockup
4. **技术务实**：选择用户最熟悉、最快速的技术栈，不追求最优架构
5. **用户能跑**：交付物必须是用户能独立启动和运行的，所有步骤都在用户能理解的范围内

## 实现流程

### 第一步：了解用户技术背景

**必须先执行**：读取项目目录中的 `user-profile.md`。如果文件不存在或技术背景信息不足，主动询问：

- 你熟悉哪些编程语言？（如 Python、JavaScript、不会编程等）
- 你用过哪些框架或工具？（如 React、Vue、Flask、WordPress 等）
- 你有没有自己部署过项目？（如用过 Vercel、自己的服务器、从没部署过等）
- 你希望 MVP 以什么形式交付？（如 Web 应用、命令行工具、桌面应用等）

将获取到的信息更新到 `user-profile.md`。

**根据技术水平确定沟通策略**：

| 用户类型 | 沟通方式 | 技术栈选择 | 交付方式 |
|---------|---------|----------|---------|
| 有经验的开发者 | 直接讨论技术方案 | 用户偏好的技术栈 | 代码 + 简要说明 |
| 有基础但不熟练 | 解释关键决策的原因 | 用户接触过的技术 + 必要引导 | 代码 + 逐步运行指南 |
| 非技术背景 | 用类比和日常语言解释 | 最简方案（如无代码/低代码优先） | 代码 + 手把手运行教程 |

### 第二步：确认 MVP 范围

基于阶段二的技术可行性评估，与用户确认：

1. **核心功能清单**：列出 MVP 必须包含的功能（通常 3-5 个）
2. **明确不做清单**：列出 V2 再做的功能，避免范围蔓延
3. **核心用户旅程**：描述用户从打开产品到完成核心任务的完整路径

**确认模板**：
```
MVP 核心功能：
1. [功能 A] — 因为 [理由]
2. [功能 B] — 因为 [理由]
3. [功能 C] — 因为 [理由]

明确不做：
- [功能 X] — 延后到 V2
- [功能 Y] — 延后到 V2

核心用户旅程：
用户打开 → [步骤 1] → [步骤 2] → ... → 完成核心任务
```

### 第三步：技术方案设计

1. **技术栈选择**：基于 `user-profile.md` 中的技术背景确定
2. **项目结构**：设计清晰的目录结构
3. **关键架构决策**：数据存储方案、API 设计、第三方服务选择
4. **环境准备**：依赖安装、环境变量配置

**技术栈选择优先级**：
1. 用户已熟悉且能独立维护的技术 — **最高优先**
2. 用户接触过、稍加引导能上手的技术
3. 用户不熟悉但项目必需的技术 — 需在用户能理解的层度上解释为什么必须用，并提供学习指引
4. 如果用户完全无技术背景，优先考虑无代码/低代码方案

**向用户解释技术选择时**：
- 读取 `user-profile.md`，根据用户的认知水平调整解释深度
- 技术用户：直接说明技术选型理由（性能、生态、部署便利性等）
- 非技术用户：用类比解释（如"Next.js 就像一个帮你把网页打包好的工具箱"）
- 避免使用用户不理解的术语，如必须使用则当场解释

### 第四步：逐步实现

按功能模块逐步编码，每个模块遵循：

1. **先搭骨架**：建立基本的项目结构和路由
2. **核心逻辑优先**：先实现业务逻辑，再处理 UI
3. **模块化推进**：每完成一个功能模块，确保可运行，然后推进下一个
4. **与用户同步**：关键节点与用户确认方向是否正确

**编码规范**：
- 代码简洁清晰，适当注释关键逻辑
- 使用环境变量管理敏感配置
- 错误处理覆盖核心流程
- 保持依赖最小化

### 第五步：运行指引

确保用户能独立把 MVP 跑起来。根据用户技术水平提供不同详细程度的指引：

**基础版**（有经验的开发者）：
```
## 本地运行
1. 安装依赖：`npm install`
2. 配置环境变量：复制 `.env.example` 为 `.env`，填入 [具体配置]
3. 启动：`npm run dev`
```

**详细版**（有基础但不熟练）：
```
## 本地运行

### 前置条件
- 安装 Node.js（版本 18+）：[下载链接]
- 安装方法：[具体步骤]

### 启动步骤
1. 打开终端（Mac: 按 Cmd+空格 搜索"终端"；Windows: 搜索"PowerShell"）
2. 进入项目目录：`cd [项目路径]`
3. 安装依赖：`npm install`（首次运行需要，之后不需要）
4. 配置环境变量：[逐项说明每个变量是什么、去哪里获取]
5. 启动项目：`npm run dev`
6. 打开浏览器访问：http://localhost:3000
```

**手把手版**（非技术背景）：
- 每个步骤配截图说明或预期输出
- 解释每条命令在做什么
- 预判可能遇到的错误并给出解决方案
- 如果过于复杂，考虑提供一键启动脚本

### 第六步：部署准备

1. **部署方案选择**（根据用户技术水平推荐）：
   - 零运维方案：Vercel / Netlify / EdgeOne Pages（适合前端项目）
   - 简单运维：Railway / Fly.io / CloudBase（适合全栈应用）
   - 自主运维：用户自己的服务器（仅推荐给有运维经验的用户）

2. **部署配置**：
   - 环境变量配置说明
   - 构建命令和启动命令
   - 域名配置（可选）

3. **上线清单**：
   - [ ] 核心功能可用
   - [ ] 错误处理正常
   - [ ] 环境变量已配置
   - [ ] 部署成功且可访问

## 输出物

完成阶段三后，交付：
1. **可运行的代码**：完整的项目代码
2. **启动说明**：匹配用户技术水平的本地运行指南
3. **部署指南**：匹配用户能力的部署方式和步骤
4. **后续建议**：V2 功能优先级和迭代方向
