---
name: idea-coach
description: AI-powered idea/problem/challenge manager with GitHub integration. Captures, categorizes, reviews, and helps ship ideas to repos.
version: 0.2.0
author: moinsen-dev
commands:
  - /idea - Capture a new idea, problem, or challenge
  - /idea_list - List active ideas (optionally filter by status/type)
  - /idea_due - Show ideas due for review
  - /idea_get - Get detailed info about an idea
  - /idea_update - Update idea status, importance, energy
  - /idea_review - Add review notes to an idea
  - /idea_drop - Mark idea as dropped (with reason)
  - /idea_done - Mark idea as completed
  - /idea_stats - Show statistics
  - /idea_link - Link idea to existing GitHub repo
  - /idea_ship - Create new GitHub repo for idea
  - /idea_repo - Show linked repo status
  - /idea_sync - Sync idea as GitHub issue
---

# Idea Coach

> Your critical sparring partner for ideas, problems, and challenges — now with GitHub integration!

## What It Does

Idea Coach helps you:
- **Capture** ideas, problems, and challenges as they come
- **Categorize** by type, domain, energy, urgency, and importance
- **Review** periodically (daily → quarterly based on importance)
- **Ship** ideas to GitHub repos when ready
- **Track** progress and know when to let go

## Philosophy

**Be critical, not just supportive.** Idea Coach will:
- Suggest dropping ideas that aren't worth pursuing
- Ask hard questions during reviews
- Track which ideas actually ship vs. rot forever

## Commands

### Core Commands

| Command | Description |
|---------|-------------|
| `/idea <text>` | Capture a new idea |
| `/idea_list` | List active ideas |
| `/idea_list --due` | Show ideas due for review |
| `/idea_get <id>` | Get idea details |
| `/idea_update <id>` | Update idea attributes |
| `/idea_review <id>` | Add review interaction |
| `/idea_drop <id>` | Mark as dropped (requires reason) |
| `/idea_done <id>` | Mark as completed |
| `/idea_stats` | Show statistics |

### GitHub Commands

| Command | Description |
|---------|-------------|
| `/idea_link <id> <owner/repo>` | Link to existing repo |
| `/idea_ship <id>` | Create new repo for idea |
| `/idea_ship <id> --public` | Create public repo |
| `/idea_repo <id>` | Show linked repo status |
| `/idea_sync <id>` | Create/update GitHub issue |

## Attributes

### Types
- 💡 **idea** — Something to build or create
- 🔧 **problem** — Something to fix or solve
- 🎯 **challenge** — Something to overcome

### Status Flow
```
captured → exploring → developing → shipped/done
                ↓           ↓
             parked      blocked
                ↓
             dropped
```

### Importance → Review Cycle
| Importance | Energy | Review Cycle |
|------------|--------|--------------|
| critical | high | daily |
| critical | * | weekly |
| important | high | weekly |
| important | * | biweekly |
| nice-to-have | * | monthly |
| parked | * | quarterly |

## GitHub Integration

### Prerequisites
- `gh` CLI installed and authenticated
- Run `gh auth login` if not set up

### Workflow Example

```
# 1. Capture idea
/idea "Build a CLI for task management"

# 2. Develop it
/idea_update abc123 --status developing

# 3. Ship it to GitHub
/idea_ship abc123

# 4. Or link to existing repo
/idea_link abc123 moinsen-dev/my-cli

# 5. Check repo status
/idea_repo abc123

# 6. Sync as GitHub issue
/idea_sync abc123
```

## CLI Usage

```bash
# Add idea
python scripts/coach.py add "Build something cool" --type idea --importance important

# List ideas
python scripts/coach.py list
python scripts/coach.py list --due
python scripts/coach.py list --github  # Only with linked repos

# GitHub operations
python scripts/coach.py link <id> owner/repo
python scripts/coach.py ship <id> --owner moinsen-dev
python scripts/coach.py repo-status <id>
python scripts/coach.py sync-issue <id> --labels enhancement,idea
```

## Data Storage

Ideas are stored in `~/.openclaw/idea-coach/ideas.json`

Each idea tracks:
- Basic info (title, description, type, domain)
- Status and progress
- Energy, urgency, importance
- Review schedule and history
- **GitHub integration** (repo, issue, sync timestamps)
- Interaction log

## Tips

1. **Capture quickly** — Don't overthink the initial capture
2. **Review honestly** — Use reviews to kill stale ideas
3. **Ship early** — Create a repo as soon as an idea has momentum
4. **Sync issues** — Use GitHub issues for detailed tracking
5. **Drop freely** — A dropped idea is a decision, not a failure
