# 💡 Idea Coach

> AI-powered idea/problem/challenge manager with GitHub integration.

An OpenClaw skill that helps you capture, categorize, review, and **ship** your ideas.

## Features

- ✅ **Capture** ideas, problems, and challenges
- ✅ **Categorize** by type, domain, energy, urgency, importance
- ✅ **Review cycles** based on importance (daily → quarterly)
- ✅ **GitHub integration** — link or create repos
- ✅ **Issue sync** — turn ideas into trackable GitHub issues
- ✅ **Critical feedback** — suggests dropping stale ideas

## Installation

### As OpenClaw Skill

```bash
# Coming soon to ClawHub
clawhub install idea-coach
```

### Manual Installation

```bash
git clone https://github.com/moinsen-dev/idea-coach.git
# Copy to your OpenClaw skills directory
```

## Requirements

- Python 3.8+
- `gh` CLI (for GitHub integration)
  ```bash
  # macOS
  brew install gh
  
  # Linux
  sudo apt install gh
  
  # Then authenticate
  gh auth login
  ```

## Quick Start

```bash
# Capture an idea
python scripts/coach.py add "Build a CLI for X" --type idea --importance important

# List your ideas
python scripts/coach.py list

# Check what's due for review
python scripts/coach.py due

# Ship an idea to GitHub
python scripts/coach.py ship <id>

# Link to existing repo
python scripts/coach.py link <id> owner/repo

# Get repo status
python scripts/coach.py repo-status <id>
```

## OpenClaw Commands

| Command | Description |
|---------|-------------|
| `/idea <text>` | Capture new idea |
| `/idea_list` | List active ideas |
| `/idea_due` | Show due for review |
| `/idea_ship <id>` | Create GitHub repo |
| `/idea_link <id> <repo>` | Link to existing repo |
| `/idea_repo <id>` | Show repo status |
| `/idea_sync <id>` | Sync as GitHub issue |

## Philosophy

**Be critical, not just supportive.**

- Ideas that sit too long get flagged
- Review prompts ask hard questions
- Dropping an idea is a valid decision
- Shipped > Perfect

## Status Flow

```
captured → exploring → developing → shipped/done
                ↓           ↓
             parked      blocked
                ↓
             dropped
```

## Data

Ideas stored in `~/.openclaw/idea-coach/ideas.json`

## License

MIT

---

Built for [OpenClaw](https://openclaw.ai) 🦞
