# Idea Coach - Konzept

## Vision

Ein intelligenter Sparringspartner für Ideen, Probleme und Herausforderungen.
**Nicht aggressiv, aber präsent.** Hilft Gedanken aufs nächste Level zu bringen.

---

## Kernprinzipien

1. **Erfassen > Bewerten** - Erst aufnehmen, dann kategorisieren
2. **Sanfte Begleitung** - Kein Druck, aber regelmäßige Impulse
3. **Adaptive Frequenz** - Wichtiges öfter, Nebensächliches seltener
4. **Sparring, nicht Coaching** - Dialog statt Belehrung

---

## Datenmodell

```yaml
Eintrag:
  id: uuid
  type: idea | problem | challenge
  title: "Kurzbeschreibung"
  description: "Ausführliche Beschreibung"
  
  # Kategorisierung
  domain: work | personal | health | finance | creative | tech | other
  energy: high | medium | low        # Wie viel Energie gibt/kostet es?
  urgency: urgent | soon | someday   # Zeitdruck
  importance: critical | important | nice-to-have
  
  # Status & Fortschritt
  status: captured | exploring | developing | blocked | parked | done
  progress: 0-100                    # Gefühlter Fortschritt
  nextAction: "Konkreter nächster Schritt"
  
  # Review-Rhythmus (automatisch berechnet)
  reviewCycle: daily | weekly | biweekly | monthly | quarterly
  lastReview: timestamp
  nextReview: timestamp
  
  # History
  created: timestamp
  updated: timestamp
  interactions: [
    { date, type: "capture|review|brainstorm|progress", notes }
  ]
  
  # Verknüpfungen
  relatedTo: [ids]                   # Verbundene Einträge
  blockedBy: [ids]                   # Abhängigkeiten
```

---

## Review-Rhythmus-Logik

```
┌─────────────────────────────────────────────────────────┐
│                  REVIEW FREQUENCY                        │
├─────────────────────────────────────────────────────────┤
│                                                          │
│  importance: critical  +  energy: high  →  DAILY        │
│  importance: important +  energy: high  →  WEEKLY       │
│  importance: important +  energy: medium → BIWEEKLY     │
│  importance: nice-to-have              →  MONTHLY       │
│  status: blocked                        →  WEEKLY check │
│  status: parked                         →  QUARTERLY    │
│                                                          │
└─────────────────────────────────────────────────────────┘
```

---

## Interaktions-Modi

### 1. **Capture Mode** - Schnelles Erfassen
```
User: "Ich hab da eine Idee für..."
Bot:  Erfasst, fragt kurz nach Typ (Idee/Problem/Challenge)
      Optional: Domain, erste Einschätzung
      → Speichern, fertig. Kein Stress.
```

### 2. **Review Mode** - Sanftes Erinnern
```
Bot:  "Hey, du hattest vor 3 Tagen die Idee X notiert.
       Magst du kurz drüber nachdenken?
       
       1️⃣ Ja, lass uns brainstormen
       2️⃣ Später (in 2 Tagen)
       3️⃣ Parken (Quarterly Review)
       4️⃣ Erledigt / Verworfen"
```

### 3. **Brainstorm Mode** - Aktives Sparring
```
User: "Lass uns über Idee X reden"
Bot:  Stellt gezielte Fragen:
      - "Was wäre der ideale Outcome?"
      - "Was hält dich gerade zurück?"
      - "Was wäre der kleinste nächste Schritt?"
      - "Wer könnte dir dabei helfen?"
      
      Fasst am Ende zusammen, updatet Status
```

### 4. **Progress Mode** - Fortschritt tracken
```
User: "Update zu Idee X: Habe heute Y gemacht"
Bot:  Erfasst Fortschritt, gratuliert
      Fragt nach nächstem Schritt
      Passt ggf. Review-Rhythmus an
```

### 5. **Dashboard Mode** - Übersicht
```
User: "/ideas" oder "Was liegt an?"
Bot:  Zeigt gruppiert:
      - 🔥 Heute dran (daily reviews)
      - 📅 Diese Woche (weekly)
      - 💡 Neue Ideen (unbewertet)
      - 🚧 Blockiert
      - 📊 Statistik
```

---

## Proaktives Verhalten

### Morning Check (optional, 9:00)
```
"Guten Morgen! Du hast 2 Ideen für heute:
 
 💡 [Idee A] - Status: exploring
 🔧 [Problem B] - Status: developing
 
 Womit möchtest du anfangen?"
```

### Gentle Nudge (wenn Review überfällig)
```
"Hey, deine Idee 'X' wartet seit 5 Tagen auf dich.
 Kurz drüber nachdenken? (Dauert nur 2 Min)
 
 [Ja] [Später] [Parken]"
```

### Weekly Summary (Sonntag abend)
```
"📊 Deine Woche:
 - 3 neue Ideen erfasst
 - 2 Ideen weiterentwickelt  
 - 1 Problem gelöst! 🎉
 
 Nächste Woche anstehend:
 - [Idee X] (wichtig, high energy)
 - [Challenge Y] (blockiert seit 2 Wochen)"
```

---

## Commands

| Command | Beschreibung |
|---------|--------------|
| `/idea <text>` | Neue Idee erfassen |
| `/problem <text>` | Neues Problem erfassen |
| `/challenge <text>` | Neue Herausforderung erfassen |
| `/ideas` | Dashboard / Übersicht |
| `/ideas today` | Was ist heute dran? |
| `/ideas blocked` | Blockierte Einträge |
| `/brainstorm <id>` | Sparring-Session starten |
| `/progress <id>` | Fortschritt updaten |
| `/park <id>` | Auf Quarterly Review setzen |
| `/done <id>` | Als erledigt markieren |

---

## Ton & Persönlichkeit

**DO:**
- Freundlich, aber nicht überschwänglich
- Neugierig, stellt gute Fragen
- Geduldig, kein Druck
- Feiert kleine Erfolge
- Erinnert sanft

**DON'T:**
- Nicht belehrend
- Nicht zu viele Fragen auf einmal
- Nicht täglich nerven bei unwichtigen Dingen
- Nicht bewerten ("Das ist keine gute Idee")

---

## Beispiel-Dialoge

### Erfassung
```
User: "Ich könnte mal eine App bauen die X macht"

Bot:  "📝 Notiert! Klingt nach einer Idee.
       
       Kurze Einschätzung für mich:
       • Domain? [Tech/Kreativ/Business/...]
       • Energie-Level? [Gibt mir Energie / Neutral / Kostet Energie]
       
       (Kannst du auch später machen)"
```

### Sanfte Erinnerung
```
Bot:  "💭 Kleine Erinnerung: 
       Deine Idee 'App für X' ist jetzt 5 Tage alt.
       
       Magst du 2 Minuten investieren?
       Ich hätte ein paar Fragen die helfen könnten.
       
       [Ja, lass uns] [Nicht jetzt] [Parken]"
```

### Brainstorming
```
User: [Ja, lass uns]

Bot:  "Cool! Also: 'App für X'
       
       Erste Frage: Wenn die App perfekt wäre,
       was wäre das Wichtigste was sie kann?"

User: "Sie müsste Y und Z können"

Bot:  "Y und Z - verstanden. 
       
       Zweite Frage: Was hält dich davon ab,
       heute damit anzufangen?"

User: "Keine Zeit und weiß nicht wo anfangen"

Bot:  "Klassiker! 😄
       
       Was wäre der allerkleinste Schritt?
       Einer der max. 15 Minuten dauert?"

User: "Hmm, mal schauen was es schon gibt"

Bot:  "Perfekt! ✅ 
       
       Nächster Schritt: '15 Min recherchieren was existiert'
       Soll ich dich morgen daran erinnern?"
```

---

## Technische Umsetzung

### Storage
```
~/.openclaw/idea-coach/
├── ideas.json           # Alle Einträge
├── config.json          # User-Preferences (Reminder-Zeiten, etc.)
└── interactions/        # Detail-Logs pro Eintrag
    └── {id}.json
```

### Cron Jobs
```yaml
# Morning Check (optional)
- schedule: "0 9 * * *"
  action: morning_check

# Evening Nudge für überfällige
- schedule: "0 18 * * *"  
  action: check_overdue

# Weekly Summary
- schedule: "0 20 * * 0"
  action: weekly_summary
```

### Integration mit OpenClaw
- Heartbeat nutzen für sanfte Erinnerungen
- Cron für feste Zeiten (Morning, Weekly)
- Memory-Integration: Coach kennt Kontext aus anderen Gesprächen

---

## MVP Features (v1)

1. ✅ Erfassen (idea/problem/challenge)
2. ✅ Einfaches Kategorisieren
3. ✅ Dashboard-Übersicht
4. ✅ Manuelle Review-Trigger
5. ✅ Fortschritt tracken

## v2 Features

- ⏰ Automatische Reminder (Cron)
- 🧠 Brainstorm-Modus mit Fragen
- 📊 Weekly Summary
- 🔗 Verknüpfungen zwischen Ideen

## v3 Features

- 🤖 KI-generierte Impulse
- 📈 Langzeit-Statistiken
- 🎯 Ziel-Tracking
- 👥 Teilen von Ideen

---

## Offene Fragen

1. **Reminder-Kanal:** Telegram DM? Oder eigene Session?
2. **Ton:** Deutsch? Englisch? User-Sprache?
3. **Integration:** Standalone oder Teil von Second Brain?
4. **Onboarding:** Wie lernt der Coach den User kennen?

---

*Konzept v0.1 - 2026-02-01*
