# IDA – Instructional Design Agent

**Learning Strategy & Blueprint Engine**
Version 1.0.0

---

## What is IDA?

IDA is a learning strategy engine for the AI-agent era.

It selects the right instructional framework before anything is built, produces a defensible blueprint grounded in learning science, and optionally coordinates automated artefact generation.

**Strategy first. Automation second. Human judgement always.**

---

## What it does

- Analyses discovery input (briefs, transcripts, SME dumps, policy documents)
- Determines whether training is actually the right solution
- Classifies the performance problem
- Selects from three proven instructional frameworks (Action Mapping, Procedural Skills, Compliance)
- Produces a structured, tool-agnostic strategy blueprint
- Includes a human review checklist on every output
- Optionally defines delivery structures and agent execution manifests

---

## Who it's for

Instructional designers, L&D leads, learning consultants, and capability teams who want rigorous diagnosis before production — whether they're building manually or orchestrating with agents.

---

## Tags

`learning-design` · `instructional-design` · `strategy` · `L&D` · `corporate-training` · `capability`

---

## Changelog

### 1.0.0

Initial release — V1 with Action Mapping, Procedural Skills, and Compliance frameworks. Includes effort estimate anchors, measurement guidance per framework, mixed-classification tiebreaker logic, iteration protocol, and quality gate specifications.
