#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Extended translations part 2: Korean, Portuguese, Polish, Turkish, Hindi
"""

EXTENDED_TRANSLATIONS_2 = {
    'ko': {
        'setup_title': '🔧 iCalendar Sync 설정',
        'setup_intro': 'iCalendar Sync를 사용하려면 iCloud 자격 증명을 구성해야 합니다.',
        'setup_warning': '⚠️  일반 Apple ID 비밀번호가 아닌 앱별 비밀번호를 사용하세요.',
        'setup_url': '획득: https://appleid.apple.com -> 로그인 및 보안 -> 앱별 비밀번호',
        'email_prompt': '📧 iCloud 이메일: ',
        'password_prompt': '🔑 앱별 비밀번호 (xxxx-xxxx-xxxx-xxxx): ',
        'email_empty': '❌ 이메일을 비워 둘 수 없습니다',
        'password_empty': '❌ 비밀번호를 비워 둘 수 없습니다',
        'invalid_email': '❌ 잘못된 이메일 형식',
        'continue_anyway': '그래도 계속하시겠습니까? (y/n): ',
        'password_unusual': '⚠️  비밀번호 형식이 비정상적으로 보입니다',
        'are_you_sure': '이것이 맞습니까? (y/n): ',
        'setup_cancelled': '설정이 취소되었습니다',
        'credentials_saved_keyring': '✅ 자격 증명이 시스템 키체인에 안전하게 저장되었습니다',
        'keyring_fallback': '⚠️  시스템 키체인에 액세스할 수 없습니다. .env 파일로 대체합니다',
        'credentials_saved_file': '✅ 구성이 {path}에 안전하게 저장되었습니다',
        'ready_to_use': '🚀 이제 iCalendar Sync를 사용할 수 있습니다!',
        'available_calendars': '📅 사용 가능한 일정 ({count}): ',
        'events_in_calendar': '📋 \'{name}\'의 일정 ({count}개 발견): ',
        'event_created': '✅ 일정 \'{summary}\'가 성공적으로 생성되었습니다',
        'event_deleted': '🗑️  일정이 성공적으로 삭제되었습니다',
        'error_required_packages': '❌ 필수 패키지가 설치되지 않았습니다: {error}',
        'error_run_install': '실행: pip install -r requirements.txt',
        'error_credentials_missing': '❌ iCloud 자격 증명이 구성되지 않았습니다',
        'error_auth_failed': '❌ 인증 실패: 잘못된 자격 증명',
        'error_network': '❌ 네트워크 오류',
        'error_caldav': '❌ CalDAV 오류',
        'error_unexpected': '❌ 예상치 못한 오류: {type}',
        'error_calendars_not_found': '❌ 일정을 찾을 수 없습니다',
        'error_calendar_not_found': '❌ 일정 \'{name}\'을 찾을 수 없습니다',
        'error_events': '❌ 일정 가져오기 오류',
        'error_listing_calendars': '❌ 일정 목록 표시 오류',
        'error_invalid_calendar_name': '❌ 잘못된 일정 이름',
        'error_days_range': '❌ days_ahead는 {min}과 {max} 사이여야 합니다',
        'error_missing_fields': '❌ 필수 필드 누락: {fields}',
        'error_dtstart_type': '❌ dtstart는 datetime 객체여야 합니다',
        'error_dtend_type': '❌ dtend는 datetime 객체여야 합니다',
        'error_time_range': '❌ 일정 종료 시간은 시작 시간 이후여야 합니다',
        'error_creating_event': '❌ 일정 생성 오류',
        'error_event_not_found': '❌ 일정 또는 일정을 찾을 수 없습니다',
        'error_deleting_event': '❌ 일정 삭제 오류',
        'error_invalid_uid': '❌ 유효한 일정 UID가 필요합니다',
        'error_uid_too_long': '❌ 잘못된 일정 UID (너무 깁니다)',
        'error_calendar_required': '❌ 일정 이름이 필요합니다',
        'error_json_required': '❌ 일정과 JSON 데이터가 필요합니다',
        'error_json_read': '❌ JSON 파일을 읽을 수 없습니다',
        'error_json_too_large': '❌ JSON 데이터가 너무 큽니다',
        'error_invalid_json': '❌ 잘못된 JSON: {error}',
        'error_invalid_datetime': '❌ 잘못된 날짜/시간 형식: {error}',
        'error_uid_required': '❌ 일정과 일정 UID가 필요합니다',
        'warning_conflicts': '⚠️  경고: {count}개의 충돌하는 일정을 찾았습니다:',
        'warning_conflict_item': '   - {summary} ({start} ~ {end})',
        'confirm_continue': '그래도 계속하시겠습니까? (y/n): ',
        'creation_cancelled': '일정 생성이 취소되었습니다',
        'input_timeout': '⏱️  입력 시간 초과',
        'using_cached_connection': '캐시된 CalDAV 연결을 사용 중',
        'connection_successful': 'iCloud CalDAV에 성공적으로 연결되었습니다',
        'found_calendar': '일정을 찾았습니다: {name}',
        'found_event': '일정을 찾았습니다: {summary}',
        'loaded_from_keyring': '키체인에서 비밀번호를 불러왔습니다',
    },
    
    'pt': {
        'setup_title': '🔧 Configuração do iCalendar Sync',
        'setup_intro': 'Para usar o iCalendar Sync, precisa configurar as suas credenciais do iCloud.',
        'setup_warning': '⚠️  Use uma Palavra-passe Específica da Aplicação, NÃO a sua palavra-passe normal do Apple ID.',
        'setup_url': 'Obtenha em: https://appleid.apple.com -> Início de Sessão e Segurança -> Palavras-passe Específicas da Aplicação',
        'email_prompt': '📧 Email do iCloud: ',
        'password_prompt': '🔑 Palavra-passe Específica (xxxx-xxxx-xxxx-xxxx): ',
        'email_empty': '❌ O email não pode estar vazio',
        'password_empty': '❌ A palavra-passe não pode estar vazia',
        'invalid_email': '❌ Formato de email inválido',
        'continue_anyway': 'Continuar mesmo assim? (s/n): ',
        'password_unusual': '⚠️  O formato da palavra-passe parece inválido',
        'are_you_sure': 'Tem a certeza que está correto? (s/n): ',
        'setup_cancelled': 'Configuração cancelada',
        'credentials_saved_keyring': '✅ Credenciais guardadas com segurança no porta-chaves do sistema',
        'keyring_fallback': '⚠️  Não foi possível aceder ao porta-chaves do sistema, a usar ficheiro .env',
        'credentials_saved_file': '✅ Configuração guardada com segurança em {path}',
        'ready_to_use': '🚀 Já pode usar o iCalendar Sync!',
        'available_calendars': '📅 Calendários Disponíveis ({count}):',
        'events_in_calendar': '📋 Eventos em \'{name}\' ({count} encontrados):',
        'event_created': '✅ Evento \'{summary}\' criado com sucesso',
        'event_deleted': '🗑️  Evento eliminado com sucesso',
        'error_required_packages': '❌ Pacotes necessários não instalados: {error}',
        'error_run_install': 'Execute: pip install -r requirements.txt',
        'error_credentials_missing': '❌ Credenciais do iCloud não configuradas',
        'error_auth_failed': '❌ Autenticação falhou: Credenciais inválidas',
        'error_network': '❌ Erro de rede',
        'error_caldav': '❌ Erro CalDAV',
        'error_unexpected': '❌ Erro inesperado: {type}',
        'error_calendars_not_found': '❌ Calendários não encontrados',
        'error_calendar_not_found': '❌ Calendário \'{name}\' não encontrado',
        'error_events': '❌ Erro ao obter eventos',
        'error_listing_calendars': '❌ Erro ao listar calendários',
        'error_invalid_calendar_name': '❌ Nome de calendário inválido',
        'error_days_range': '❌ days_ahead deve estar entre {min} e {max}',
        'error_missing_fields': '❌ Campos obrigatórios em falta: {fields}',
        'error_dtstart_type': '❌ dtstart deve ser um objeto datetime',
        'error_dtend_type': '❌ dtend deve ser um objeto datetime',
        'error_time_range': '❌ A hora de fim do evento deve ser posterior à hora de início',
        'error_creating_event': '❌ Erro ao criar evento',
        'error_event_not_found': '❌ Evento ou calendário não encontrado',
        'error_deleting_event': '❌ Erro ao eliminar evento',
        'error_invalid_uid': '❌ É necessário um UID de evento válido',
        'error_uid_too_long': '❌ UID de evento inválido (demasiado longo)',
        'error_calendar_required': '❌ Nome de calendário necessário',
        'error_json_required': '❌ Calendário e dados JSON necessários',
        'error_json_read': '❌ Não foi possível ler o ficheiro JSON',
        'error_json_too_large': '❌ Dados JSON demasiado grandes',
        'error_invalid_json': '❌ JSON inválido: {error}',
        'error_invalid_datetime': '❌ Formato de data/hora inválido: {error}',
        'error_uid_required': '❌ Calendário e UID de evento necessários',
        'warning_conflicts': '⚠️  Aviso: {count} evento(s) em conflito encontrado(s):',
        'warning_conflict_item': '   - {summary} ({start} a {end})',
        'confirm_continue': 'Continuar mesmo assim? (s/n): ',
        'creation_cancelled': 'Criação de evento cancelada',
        'input_timeout': '⏱️  Tempo limite de entrada',
        'using_cached_connection': 'A usar ligação CalDAV em cache',
        'connection_successful': 'Ligado com sucesso ao iCloud CalDAV',
        'found_calendar': 'Calendário encontrado: {name}',
        'found_event': 'Evento encontrado: {summary}',
        'loaded_from_keyring': 'Palavra-passe carregada do porta-chaves',
    },
    
    'pt-br': {
        'setup_title': '🔧 Configuração do iCalendar Sync',
        'setup_intro': 'Para usar o iCalendar Sync, você precisa configurar suas credenciais do iCloud.',
        'setup_warning': '⚠️  Use uma Senha Específica do App, NÃO sua senha normal do Apple ID.',
        'setup_url': 'Obtenha em: https://appleid.apple.com -> Login e Segurança -> Senhas Específicas do App',
        'email_prompt': '📧 Email do iCloud: ',
        'password_prompt': '🔑 Senha Específica do App (xxxx-xxxx-xxxx-xxxx): ',
        'email_empty': '❌ O email não pode estar vazio',
        'password_empty': '❌ A senha não pode estar vazia',
        'invalid_email': '❌ Formato de email inválido',
        'continue_anyway': 'Continuar mesmo assim? (s/n): ',
        'password_unusual': '⚠️  O formato da senha parece inválido',
        'are_you_sure': 'Você tem certeza que está correto? (s/n): ',
        'setup_cancelled': 'Configuração cancelada',
        'credentials_saved_keyring': '✅ Credenciais salvas com segurança no chaveiro do sistema',
        'keyring_fallback': '⚠️  Não foi possível acessar o chaveiro do sistema, usando arquivo .env',
        'credentials_saved_file': '✅ Configuração salva com segurança em {path}',
        'ready_to_use': '🚀 Você já pode usar o iCalendar Sync!',
        'available_calendars': '📅 Calendários Disponíveis ({count}):',
        'events_in_calendar': '📋 Eventos em \'{name}\' ({count} encontrados):',
        'event_created': '✅ Evento \'{summary}\' criado com sucesso',
        'event_deleted': '🗑️  Evento excluído com sucesso',
        'error_required_packages': '❌ Pacotes necessários não instalados: {error}',
        'error_run_install': 'Execute: pip install -r requirements.txt',
        'error_credentials_missing': '❌ Credenciais do iCloud não configuradas',
        'error_auth_failed': '❌ Autenticação falhou: Credenciais inválidas',
        'error_network': '❌ Erro de rede',
        'error_caldav': '❌ Erro CalDAV',
        'error_unexpected': '❌ Erro inesperado: {type}',
        'error_calendars_not_found': '❌ Calendários não encontrados',
        'error_calendar_not_found': '❌ Calendário \'{name}\' não encontrado',
        'error_events': '❌ Erro ao obter eventos',
        'error_listing_calendars': '❌ Erro ao listar calendários',
        'error_invalid_calendar_name': '❌ Nome de calendário inválido',
        'error_days_range': '❌ days_ahead deve estar entre {min} e {max}',
        'error_missing_fields': '❌ Campos obrigatórios faltando: {fields}',
        'error_dtstart_type': '❌ dtstart deve ser um objeto datetime',
        'error_dtend_type': '❌ dtend deve ser um objeto datetime',
        'error_time_range': '❌ O horário de término do evento deve ser posterior ao horário de início',
        'error_creating_event': '❌ Erro ao criar evento',
        'error_event_not_found': '❌ Evento ou calendário não encontrado',
        'error_deleting_event': '❌ Erro ao excluir evento',
        'error_invalid_uid': '❌ É necessário um UID de evento válido',
        'error_uid_too_long': '❌ UID de evento inválido (muito longo)',
        'error_calendar_required': '❌ Nome de calendário necessário',
        'error_json_required': '❌ Calendário e dados JSON necessários',
        'error_json_read': '❌ Não foi possível ler o arquivo JSON',
        'error_json_too_large': '❌ Dados JSON muito grandes',
        'error_invalid_json': '❌ JSON inválido: {error}',
        'error_invalid_datetime': '❌ Formato de data/hora inválido: {error}',
        'error_uid_required': '❌ Calendário e UID de evento necessários',
        'warning_conflicts': '⚠️  Aviso: {count} evento(s) em conflito encontrado(s):',
        'warning_conflict_item': '   - {summary} ({start} às {end})',
        'confirm_continue': 'Continuar mesmo assim? (s/n): ',
        'creation_cancelled': 'Criação de evento cancelada',
        'input_timeout': '⏱️  Tempo limite de entrada',
        'using_cached_connection': 'Usando conexão CalDAV em cache',
        'connection_successful': 'Conectado com sucesso ao iCloud CalDAV',
        'found_calendar': 'Calendário encontrado: {name}',
        'found_event': 'Evento encontrado: {summary}',
        'loaded_from_keyring': 'Senha carregada do chaveiro',
    },
}
