#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Extended translations for major world languages
Adds: Chinese, Japanese, Korean, Portuguese, Polish, Turkish, Hindi
"""

EXTENDED_TRANSLATIONS = {
    'zh-cn': {
        'setup_title': '🔧 iCalendar Sync 设置',
        'setup_intro': '要使用 iCalendar Sync，您需要配置 iCloud 凭据。',
        'setup_warning': '⚠️  请使用应用专用密码，不是您的常规 Apple ID 密码。',
        'setup_url': '获取地址：https://appleid.apple.com -> 登录与安全 -> 应用专用密码',
        'email_prompt': '📧 iCloud 电子邮件：',
        'password_prompt': '🔑 应用专用密码 (xxxx-xxxx-xxxx-xxxx)：',
        'email_empty': '❌ 电子邮件不能为空',
        'password_empty': '❌ 密码不能为空',
        'invalid_email': '❌ 电子邮件格式无效',
        'continue_anyway': '仍然继续？(y/n)：',
        'password_unusual': '⚠️  密码格式看起来不寻常',
        'are_you_sure': '您确定这是正确的吗？(y/n)：',
        'setup_cancelled': '设置已取消',
        'credentials_saved_keyring': '✅ 凭据已安全保存到系统钥匙串',
        'keyring_fallback': '⚠️  无法访问系统钥匙串，回退到 .env 文件',
        'credentials_saved_file': '✅ 配置已安全保存到 {path}',
        'ready_to_use': '🚀 您现在可以使用 iCalendar Sync 了！',
        'available_calendars': '📅 可用日历 ({count})：',
        'events_in_calendar': '📋 日历 \'{name}\' 中的事件（找到 {count} 个）：',
        'event_created': '✅ 事件 \'{summary}\' 创建成功',
        'event_deleted': '🗑️  事件删除成功',
        'error_required_packages': '❌ 未安装所需的软件包：{error}',
        'error_run_install': '运行：pip install -r requirements.txt',
        'error_credentials_missing': '❌ 未配置 iCloud 凭据',
        'error_auth_failed': '❌ 身份验证失败：凭据无效',
        'error_network': '❌ 网络错误',
        'error_caldav': '❌ CalDAV 错误',
        'error_unexpected': '❌ 意外错误：{type}',
        'error_calendars_not_found': '❌ 未找到日历',
        'error_calendar_not_found': '❌ 未找到日历 \'{name}\'',
        'error_events': '❌ 获取事件时出错',
        'error_listing_calendars': '❌ 列出日历时出错',
        'error_invalid_calendar_name': '❌ 日历名称无效',
        'error_days_range': '❌ days_ahead 必须在 {min} 和 {max} 之间',
        'error_missing_fields': '❌ 缺少必填字段：{fields}',
        'error_dtstart_type': '❌ dtstart 必须是 datetime 对象',
        'error_dtend_type': '❌ dtend 必须是 datetime 对象',
        'error_time_range': '❌ 事件结束时间必须在开始时间之后',
        'error_creating_event': '❌ 创建事件时出错',
        'error_event_not_found': '❌ 未找到事件或日历',
        'error_deleting_event': '❌ 删除事件时出错',
        'error_invalid_uid': '❌ 需要有效的事件 UID',
        'error_uid_too_long': '❌ 事件 UID 无效（太长）',
        'error_calendar_required': '❌ 需要日历名称',
        'error_json_required': '❌ 需要日历和 JSON 数据',
        'error_json_read': '❌ 无法读取 JSON 文件',
        'error_json_too_large': '❌ JSON 数据太大',
        'error_invalid_json': '❌ JSON 无效：{error}',
        'error_invalid_datetime': '❌ 日期时间格式无效：{error}',
        'error_uid_required': '❌ 需要日历和事件 UID',
        'warning_conflicts': '⚠️  警告：发现 {count} 个冲突事件：',
        'warning_conflict_item': '   - {summary} ({start} 到 {end})',
        'confirm_continue': '仍然继续？(y/n)：',
        'creation_cancelled': '事件创建已取消',
        'input_timeout': '⏱️  输入超时',
        'using_cached_connection': '使用缓存的 CalDAV 连接',
        'connection_successful': '成功连接到 iCloud CalDAV',
        'found_calendar': '找到日历：{name}',
        'found_event': '找到事件：{summary}',
        'loaded_from_keyring': '从钥匙串加载密码',
    },
    
    'zh-tw': {
        'setup_title': '🔧 iCalendar Sync 設定',
        'setup_intro': '要使用 iCalendar Sync，您需要設定 iCloud 憑證。',
        'setup_warning': '⚠️  請使用應用程式專用密碼，而不是您的一般 Apple ID 密碼。',
        'setup_url': '獲取位置：https://appleid.apple.com -> 登入與安全性 -> 應用程式專用密碼',
        'email_prompt': '📧 iCloud 電子郵件：',
        'password_prompt': '🔑 應用程式專用密碼 (xxxx-xxxx-xxxx-xxxx)：',
        'email_empty': '❌ 電子郵件不能為空',
        'password_empty': '❌ 密碼不能為空',
        'invalid_email': '❌ 電子郵件格式無效',
        'continue_anyway': '仍要繼續嗎？(y/n)：',
        'password_unusual': '⚠️  密碼格式看起來不尋常',
        'are_you_sure': '您確定這是正確的嗎？(y/n)：',
        'setup_cancelled': '設定已取消',
        'credentials_saved_keyring': '✅ 憑證已安全儲存到系統鑰匙圈',
        'keyring_fallback': '⚠️  無法存取系統鑰匙圈，回退到 .env 檔案',
        'credentials_saved_file': '✅ 設定已安全儲存到 {path}',
        'ready_to_use': '🚀 您現在可以使用 iCalendar Sync 了！',
        'available_calendars': '📅 可用行事曆 ({count})：',
        'events_in_calendar': '📋 行事曆 \'{name}\' 中的事件（找到 {count} 個）：',
        'event_created': '✅ 事件 \'{summary}\' 建立成功',
        'event_deleted': '🗑️  事件刪除成功',
        'error_required_packages': '❌ 未安裝所需的套件：{error}',
        'error_run_install': '執行：pip install -r requirements.txt',
        'error_credentials_missing': '❌ 未設定 iCloud 憑證',
        'error_auth_failed': '❌ 身分驗證失敗：憑證無效',
        'error_network': '❌ 網路錯誤',
        'error_caldav': '❌ CalDAV 錯誤',
        'error_unexpected': '❌ 意外錯誤：{type}',
        'error_calendars_not_found': '❌ 找不到行事曆',
        'error_calendar_not_found': '❌ 找不到行事曆 \'{name}\'',
        'error_events': '❌ 取得事件時發生錯誤',
        'error_listing_calendars': '❌ 列出行事曆時發生錯誤',
        'error_invalid_calendar_name': '❌ 行事曆名稱無效',
        'error_days_range': '❌ days_ahead 必須介於 {min} 和 {max} 之間',
        'error_missing_fields': '❌ 缺少必填欄位：{fields}',
        'error_dtstart_type': '❌ dtstart 必須是 datetime 物件',
        'error_dtend_type': '❌ dtend 必須是 datetime 物件',
        'error_time_range': '❌ 事件結束時間必須在開始時間之後',
        'error_creating_event': '❌ 建立事件時發生錯誤',
        'error_event_not_found': '❌ 找不到事件或行事曆',
        'error_deleting_event': '❌ 刪除事件時發生錯誤',
        'error_invalid_uid': '❌ 需要有效的事件 UID',
        'error_uid_too_long': '❌ 事件 UID 無效（太長）',
        'error_calendar_required': '❌ 需要行事曆名稱',
        'error_json_required': '❌ 需要行事曆和 JSON 資料',
        'error_json_read': '❌ 無法讀取 JSON 檔案',
        'error_json_too_large': '❌ JSON 資料太大',
        'error_invalid_json': '❌ JSON 無效：{error}',
        'error_invalid_datetime': '❌ 日期時間格式無效：{error}',
        'error_uid_required': '❌ 需要行事曆和事件 UID',
        'warning_conflicts': '⚠️  警告：發現 {count} 個衝突事件：',
        'warning_conflict_item': '   - {summary} ({start} 到 {end})',
        'confirm_continue': '仍要繼續嗎？(y/n)：',
        'creation_cancelled': '事件建立已取消',
        'input_timeout': '⏱️  輸入逾時',
        'using_cached_connection': '使用快取的 CalDAV 連線',
        'connection_successful': '成功連線到 iCloud CalDAV',
        'found_calendar': '找到行事曆：{name}',
        'found_event': '找到事件：{summary}',
        'loaded_from_keyring': '從鑰匙圈載入密碼',
    },
    
    'ja': {
        'setup_title': '🔧 iCalendar Sync セットアップ',
        'setup_intro': 'iCalendar Sync を使用するには、iCloud 資格情報を設定する必要があります。',
        'setup_warning': '⚠️  通常の Apple ID パスワードではなく、App 用パスワードを使用してください。',
        'setup_url': '取得先：https://appleid.apple.com -> サインインとセキュリティ -> App 用パスワード',
        'email_prompt': '📧 iCloud メール：',
        'password_prompt': '🔑 App 用パスワード (xxxx-xxxx-xxxx-xxxx)：',
        'email_empty': '❌ メールアドレスを空にすることはできません',
        'password_empty': '❌ パスワードを空にすることはできません',
        'invalid_email': '❌ メールアドレスの形式が無効です',
        'continue_anyway': 'それでも続けますか？(y/n)：',
        'password_unusual': '⚠️  パスワードの形式が異常です',
        'are_you_sure': 'これは正しいですか？(y/n)：',
        'setup_cancelled': 'セットアップがキャンセルされました',
        'credentials_saved_keyring': '✅ 資格情報がシステムキーチェーンに安全に保存されました',
        'keyring_fallback': '⚠️  システムキーチェーンにアクセスできません。.env ファイルにフォールバックします',
        'credentials_saved_file': '✅ 設定が {path} に安全に保存されました',
        'ready_to_use': '🚀 iCalendar Sync を使用できるようになりました！',
        'available_calendars': '📅 利用可能なカレンダー ({count})：',
        'events_in_calendar': '📋 \'{name}\' のイベント（{count} 件見つかりました）：',
        'event_created': '✅ イベント \'{summary}\' が正常に作成されました',
        'event_deleted': '🗑️  イベントが正常に削除されました',
        'error_required_packages': '❌ 必要なパッケージがインストールされていません：{error}',
        'error_run_install': '実行：pip install -r requirements.txt',
        'error_credentials_missing': '❌ iCloud 資格情報が設定されていません',
        'error_auth_failed': '❌ 認証に失敗しました：資格情報が無効です',
        'error_network': '❌ ネットワークエラー',
        'error_caldav': '❌ CalDAV エラー',
        'error_unexpected': '❌ 予期しないエラー：{type}',
        'error_calendars_not_found': '❌ カレンダーが見つかりません',
        'error_calendar_not_found': '❌ カレンダー \'{name}\' が見つかりません',
        'error_events': '❌ イベントの取得中にエラーが発生しました',
        'error_listing_calendars': '❌ カレンダーのリスト表示中にエラーが発生しました',
        'error_invalid_calendar_name': '❌ カレンダー名が無効です',
        'error_days_range': '❌ days_ahead は {min} から {max} の間である必要があります',
        'error_missing_fields': '❌ 必須フィールドがありません：{fields}',
        'error_dtstart_type': '❌ dtstart は datetime オブジェクトである必要があります',
        'error_dtend_type': '❌ dtend は datetime オブジェクトである必要があります',
        'error_time_range': '❌ イベントの終了時刻は開始時刻より後である必要があります',
        'error_creating_event': '❌ イベントの作成中にエラーが発生しました',
        'error_event_not_found': '❌ イベントまたはカレンダーが見つかりません',
        'error_deleting_event': '❌ イベントの削除中にエラーが発生しました',
        'error_invalid_uid': '❌ 有効なイベント UID が必要です',
        'error_uid_too_long': '❌ イベント UID が無効です（長すぎます）',
        'error_calendar_required': '❌ カレンダー名が必要です',
        'error_json_required': '❌ カレンダーと JSON データが必要です',
        'error_json_read': '❌ JSON ファイルを読み取れませんでした',
        'error_json_too_large': '❌ JSON データが大きすぎます',
        'error_invalid_json': '❌ JSON が無効です：{error}',
        'error_invalid_datetime': '❌ 日時の形式が無効です：{error}',
        'error_uid_required': '❌ カレンダーとイベント UID が必要です',
        'warning_conflicts': '⚠️  警告：{count} 件の競合するイベントが見つかりました：',
        'warning_conflict_item': '   - {summary} ({start} から {end})',
        'confirm_continue': 'それでも続けますか？(y/n)：',
        'creation_cancelled': 'イベントの作成がキャンセルされました',
        'input_timeout': '⏱️  入力タイムアウト',
        'using_cached_connection': 'キャッシュされた CalDAV 接続を使用しています',
        'connection_successful': 'iCloud CalDAV に正常に接続されました',
        'found_calendar': 'カレンダーが見つかりました：{name}',
        'found_event': 'イベントが見つかりました：{summary}',
        'loaded_from_keyring': 'キーチェーンからパスワードを読み込みました',
    },
}
