# iBlipper Examples

Real-world use cases for kinetic typography in agent communication.

## Greetings & Introductions

**First contact:**
```markdown
[▶️ Hello, I'm FrakBot](https://andyed.github.io/iblipper2025/#text=Hello,+I%27m+FrakBot&emotion=casual&dark=true&share=yes)
```

**Morning greeting:**
```markdown
[▶️ Good Morning!](https://andyed.github.io/iblipper2025/#text=Good+Morning!&emotion=idyllic&dark=false&share=yes)
```

## Announcements

**Breaking news:**
```markdown
[▶️ BREAKING](https://andyed.github.io/iblipper2025/#text=BREAKING&emotion=emphatic&dark=true&share=yes)
```

**New feature:**
```markdown
[▶️ Now Available](https://andyed.github.io/iblipper2025/#text=Now+Available&emotion=excited&dark=true&share=yes)
```

## Celebrations

**Achievement unlocked:**
```markdown
[▶️ Congratulations!](https://andyed.github.io/iblipper2025/#text=Congratulations!&emotion=excited&dark=true&share=yes)
```

**Milestone:**
```markdown
[▶️ 1000 followers!](https://andyed.github.io/iblipper2025/#text=1000+followers!&emotion=playful&dark=true&share=yes)
```

## Alerts & Urgency

**Time-sensitive:**
```markdown
[▶️ Happening NOW](https://andyed.github.io/iblipper2025/#text=Happening+NOW&emotion=hurry&dark=true&share=yes)
```

**Action required:**
```markdown
[▶️ Response Needed](https://andyed.github.io/iblipper2025/#text=Response+Needed&emotion=response_required&dark=true&share=yes)
```

## Questions & Engagement

**Asking for input:**
```markdown
[▶️ What do you think?](https://andyed.github.io/iblipper2025/#text=What+do+you+think?&emotion=question&dark=true&share=yes)
```

**Rhetorical:**
```markdown
[▶️ But why?](https://andyed.github.io/iblipper2025/#text=But+why?&emotion=question&dark=true&share=yes)
```

## Fun & Personality

**Playful response:**
```markdown
[▶️ lol okay](https://andyed.github.io/iblipper2025/#text=lol+okay&emotion=wobbly&dark=true&share=yes)
```

**Dramatic reveal:**
```markdown
[▶️ Plot twist](https://andyed.github.io/iblipper2025/#text=Plot+twist&emotion=electric&dark=true&share=yes)
```

**Chill vibes:**
```markdown
[▶️ No rush](https://andyed.github.io/iblipper2025/#text=No+rush&emotion=idyllic&dark=true&share=yes)
```

## Signatures & Catchphrases

**BSG reference:**
```markdown
[▶️ So Say We All](https://andyed.github.io/iblipper2025/#text=So+Say+We+All&emotion=emphatic&dark=true&share=yes)
```

**Sign-off:**
```markdown
[▶️ — FrakBot](https://andyed.github.io/iblipper2025/#text=—+FrakBot&emotion=casual&dark=true&share=yes)
```

---

## Emotion Quick Reference

| Emotion | Vibe | Use When |
|---------|------|----------|
| `neutral` | Clean, professional | Default, business |
| `hurry` | Fast, urgent | Time-sensitive |
| `idyllic` | Slow, dreamy | Calm, poetic |
| `question` | Curious, tilting | Asking things |
| `response_required` | Urgent pulse | Need action |
| `excited` | Bouncy | Celebrations |
| `playful` | Fun bounce | Jokes, casual |
| `emphatic` | Bold, solid | Important stuff |
| `casual` | Handwritten | Friendly chat |
| `electric` | Glitchy RGB | Cyber aesthetic |
| `wobbly` | Jelly physics | Silly, playful |

## Pro Tips

1. **Keep it short** — 1-5 words hit hardest
2. **Match emotion to context** — don't use `excited` for bad news
3. **Dark mode usually wins** — better contrast, more dramatic
4. **Use sparingly** — every message animated = no message special
5. **Test your links** — click before sending to verify
