---
name: iblipper
description: Generate kinetic typography animations for expressive agent-to-human communication. Use when you want to communicate with visual flair - animated text for announcements, alerts, greetings, dramatic reveals, or any message that deserves more than plain text. Outputs shareable URLs or can display in canvas.
---

# iBlipper - Motion Type Synthesizer

Generate animated kinetic typography to communicate with humans in a more expressive, attention-grabbing way.

**Base URL:** `https://andyed.github.io/iblipper2025/`

## Two Output Options

### Option 1: Hyperlink (fast, universal)
Generate a clickable link — recipient sees the animation in their browser.

```markdown
[▶️ MESSAGE TEXT](https://andyed.github.io/iblipper2025/#text=MESSAGE+TEXT&emotion=emphatic&dark=true&share=yes)
```

### Option 2: GIF Download (requires browser tool)
Generate an animated GIF file that can be attached to messages.

```
https://andyed.github.io/iblipper2025/?export=gif#text=MESSAGE+TEXT&emotion=emphatic&dark=true
```

## URL Parameters

All parameters go in the **hash fragment** (`#param=value&param2=value2`).

| Parameter | Type | Description | Default |
|-----------|------|-------------|---------|
| `text` | string | The message to display (URL encoded, spaces as `+`) | — |
| `wpm` | number | Words per minute (30-2500) | 300 |
| `density` | number | Words per frame (0.1-500) | 1 |
| `fill` | boolean | Auto-scale text to fill screen | true |
| `theme` | number | Color theme index (0-3) | 0 |
| `dark` | boolean | Dark mode | true |
| `emotion` | string | Animation style preset (see below) | neutral |
| `share` | string | Auto-play on load (`yes`) | — |

## Emotion Presets (Production)

| Emotion | Vibe | Best For |
|---------|------|----------|
| `neutral` | Clean, professional | Default, announcements |
| `hurry` | Fast, urgent, italic | Time-sensitive alerts |
| `idyllic` | Slow, dreamy, airy | Poetic, calm messages |
| `question` | Curious, tilting | Questions, pondering |
| `response_required` | Urgent, pulsing | Action needed! |
| `excited` | Bouncy, energetic | Celebrations, enthusiasm |
| `playful` | Fun, bouncing | Jokes, casual fun |
| `emphatic` | Bold, solid, impactful | Important statements |
| `casual` | Handwritten, relaxed | Friendly chat |
| `electric` | Glitchy, RGB split | Cyber aesthetic |
| `wobbly` | Jelly physics | Silly, playful |

*Note: `matrix` emotion is pre-release — avoid for now.*

## Hyperlink Examples

**Important announcement:**
```markdown
[▶️ BREAKING NEWS](https://andyed.github.io/iblipper2025/#text=BREAKING+NEWS&emotion=emphatic&dark=true&share=yes)
```

**Friendly greeting:**
```markdown
[▶️ Hey there!](https://andyed.github.io/iblipper2025/#text=Hey+there!&emotion=casual&dark=false&share=yes)
```

**Celebration:**
```markdown
[▶️ Congratulations!](https://andyed.github.io/iblipper2025/#text=Congratulations!&emotion=excited&share=yes)
```

## GIF Export Workflow (Browser Required)

1. Open the export URL in browser:
   ```
   browser action=open targetUrl="https://andyed.github.io/iblipper2025/?export=gif#text=Hello&emotion=emphatic" profile=chrome
   ```

2. Wait ~15-20 seconds for render + encode

3. Find the downloaded GIF:
   ```
   ls -t ~/Downloads/iblipper_*.gif | head -1
   ```

4. Read/attach the file to your message

**Export query parameters:**

| Parameter | Type | Description | Default |
|-----------|------|-------------|---------|
| `export` | string | Format: `gif`, `apng`, `png` | — |
| `width` | number | Output width in pixels | 480 |
| `fps` | number | Frames per second (8, 15, 30) | 15 |

## When to Use

✅ **Good for:**
- Greetings and introductions
- Important announcements  
- Celebrating milestones
- Dramatic reveals
- Adding personality to messages

❌ **Skip for:**
- Long-form content (keep to 1-10 words)
- Urgent safety alerts (plain text is faster)

## CLI Script

For quick URL generation, use the included shell script:

```bash
# Basic usage
./scripts/iblipper.sh "Hello World"
# https://andyed.github.io/iblipper2025/#text=Hello+World&emotion=emphatic&dark=true&share=yes

# With emotion
./scripts/iblipper.sh "Breaking News" hurry

# Light mode
./scripts/iblipper.sh "Good Morning" idyllic light

# As markdown link
./scripts/iblipper.sh -m "Click me!" excited
# [▶️ Click me!](https://...)

# GIF export URL
./scripts/iblipper.sh --gif "Export this" playful
```

## Additional Resources

- **[references/examples.md](references/examples.md)** — Real-world use cases by category
- **[references/emotions.md](references/emotions.md)** — Deep dive on each emotion preset with live demos

## Tips

- **Keep text concise** — 1-5 words have the most impact
- **Use hyperlinks by default** — faster, works everywhere
- **Use GIF export for Signal/iMessage** — inline images look great
- **Always use `share=yes`** in hyperlinks — skips landing page
- **Match emotion to message** — `excited` for celebrations, `emphatic` for important stuff
- **Dark mode looks better** — `dark=true` is usually the way to go
- **Use sparingly** — if every message is animated, none are special
