# San Antonio & West Coast

## Overview

San Antonio (Sant Antoni de Portmany) is famous for two things: legendary sunsets and (historically) British party tourism. The reality is more nuanced. The sunset strip (Café del Mar, Mambo) is magical. The West End bar strip has a reputation. The surrounding west coast has some of Ibiza's best beaches.

## Sub-Areas

### Sunset Strip
- **Vibe**: Iconic sunsets, pre-club drinks, Instagram moments
- **Key venues**: Café del Mar, Café Mambo, Savannah, Hostal La Torre (just outside)
- **Best time**: 2 hours before sunset
- **Tip**: Reservations essential for terrace tables at main venues
- **Rent nearby**: €1,500-2,500/month

### San Antonio Bay
- **Vibe**: Family-friendly curve, water sports
- **Pros**: Calm water, easy beach access, facilities
- **Cons**: Not the prettiest beach, quite urban
- **Best for**: Families, water activities
- **Rent**: €1,200-2,000/month

### West End
- **Vibe**: British party strip, bars, clubs
- **Reality check**: Can be rowdy, lads on tour vibes
- **Pros**: Cheap drinks, lively, accessible nightlife
- **Cons**: Very loud, not sophisticated, can feel unsafe late
- **Best for**: Young party groups on budget
- **Avoid if**: You want anything upscale

### Town Center
- **Vibe**: Local Spanish town
- **Pros**: Regular shops, supermarkets, local restaurants, real life
- **Cons**: Not scenic
- **Best for**: Long-term stays, local experience
- **Rent**: €1,000-1,800/month

### Cala de Bou / Ocean Beach area
- **Vibe**: Resort strip between San Antonio and Cala Bassa
- **Pros**: Near beaches, Ocean Beach Club, modern apartments
- **Cons**: Car/taxi needed for center
- **Best for**: Beach lovers, Ocean Beach fans
- **Rent**: €1,400-2,400/month

## West Coast Beaches

### Access from San Antonio

| Beach | Distance | How | Notes |
|-------|----------|-----|-------|
| Cala Salada | 5 km | Taxi €10 / Bus / Car | Book shuttle or arrive very early |
| Cala Bassa | 8 km | Taxi €12 / Boat / Bus | CBbC beach club, parking available |
| Cala Comte | 10 km | Taxi €15 / Car | Famous sunset, arrive early |
| Cala Tarida | 7 km | Taxi €12 / Bus | Family-friendly, good facilities |
| Punta Galera | 8 km | Taxi €12 / Car | Rocky platforms, cliff jumping |

### Boat Access
- **Cala Bassa Beach Club Ferry**: From San Antonio port, regular service
- **Private charters**: Available from marina

## Practical Info

### Getting Around
- **Walking**: Town center, sunset strip, bay walkable
- **Taxi**: Essential for beaches (limited availability peak times)
- **Bus**: Connections to Ibiza Town, beaches
- **Car rental**: Very useful for beach hopping
- **Scooter**: Popular, but roads can be challenging

### Nightlife

**Sunset Pre-Game**
- Café del Mar (original, iconic)
- Café Mambo (famous for DJ sets)
- Savannah (same strip)
- Kanya (modern addition)
- Hostal La Torre (10 min north, stunning cliffs)

**Clubs & Venues**
- **O Beach**: Day club, pool party (more family-friendly than Ushuaïa)
- **Ibiza Rocks Hotel**: Pool parties, live acts
- **Eden**: Major club, various nights
- **Es Paradis**: Water park club, foam parties

**West End**: Bar Street with dozens of bars. Very much "Brits abroad" vibe.

**Getting to Other Clubs**
- Amnesia: Taxi €15-20, Disco Bus
- Pacha: Taxi €25-30, Disco Bus
- Hï/Ushuaïa: Taxi €25-30, Disco Bus
- DC-10: Taxi €30

### Dining

**Sunset Strip**
- **Café Mambo**: Drinks + tapas, sunset
- **Savannah**: Full restaurant, Mediterranean
- **Café del Mar**: Menu okay, you're paying for view

**Quality Restaurants**
- **Villa Mercedes**: Upscale, gardens, live music
- **Can Pujol**: Seafood, local favorite (also has Ibiza Town location)
- **Sa Capella**: Restaurant in old church, atmospheric

**Budget Eats**
- **Kin**: Vegetarian/vegan, excellent value
- **Local tapas bars**: In town center away from strip

**Outside Town**
- **Hostal La Torre**: Dinner with sunset views
- **Cala Bassa Beach Club**: Lunch at beach

### Services
- **Supermarkets**: Mercadona (large), Eroski, various smaller
- **Medical**: Centro de Salud Sant Antoni, pharmacies
- **Banks**: All major Spanish banks
- **Laundry**: Several options in town

## Living Here

### Pros
- Best sunsets on the island (seriously)
- Budget-friendly compared to east side
- Good west coast beach access
- Year-round local community
- Ferry to Formentera possible

### Cons
- Reputation for rowdy tourism (West End)
- Town center not charming
- Far from eastern beaches
- Club scene secondary to Playa d'en Bossa

### Best For
- Budget-conscious travelers
- Sunset enthusiasts
- West coast beach lovers
- Young party groups
- Longer-term stays (good value)

### Avoid If
- You want upscale everything
- British party tourism bothers you
- You prioritize access to Hï/Ushuaïa/Pacha
- You want charming village vibes

## Insider Tips

1. **Sunset reservations**: Book Café Mambo or Café del Mar 1-2 weeks ahead for terrace in peak season.

2. **Hostal La Torre**: 10-minute drive north for quieter, even better sunsets.

3. **Avoid West End at 2am**: Unless that's your scene. Peak drunk hour.

4. **Cala Salada shuttle**: Town runs summer shuttle because parking is impossible.

5. **Water taxi**: Fun way to reach Cala Bassa and other beaches.

6. **Off-season**: San Antonio is actually pleasant — locals reclaim the town, good restaurants stay open.

7. **O Beach vs Ushuaïa**: O Beach is less intense, more accessible, family-friendlier. Good alternative.
