# North Ibiza (San Juan, Portinatx & Surroundings)

## Overview

The north of Ibiza is the escape valve. When the south is packed with clubbers, the north remains true to old Ibiza: pine forests, small coves, hippie heritage, and the island's spiritual heart. This is wellness retreat territory, nature lovers' paradise, and where long-term residents often end up.

## Sub-Areas

### San Juan (Sant Joan de Labritja)
- **Vibe**: Authentic village, hippie heritage, community feel
- **Pros**: Sunday market, real local life, beautiful surroundings
- **Cons**: Very limited services, car essential
- **Best for**: Off-grid seekers, wellness, long-term residents
- **Rent**: €1,200-2,200/month

### Portinatx
- **Vibe**: Family resort, three coves
- **Pros**: Beautiful coves, calm water, facilities, lighthouse walk
- **Cons**: End of the road, touristy in summer, closes in winter
- **Best for**: Families, snorkeling, quiet beach days
- **Rent**: €1,400-2,400/month (summer), much less off-season

### San Miguel (Sant Miquel)
- **Vibe**: Small village, church on hill
- **Pros**: Near Can Marça caves, beautiful church, Puerto San Miguel beach
- **Cons**: Small, limited services
- **Best for**: Day trips, authentic village
- **Rent**: €1,000-1,800/month

### Puerto San Miguel
- **Vibe**: Protected bay, resort hotels
- **Pros**: Calm swimming, Hacienda Na Xamena nearby, beautiful
- **Cons**: Limited restaurants, can feel isolated
- **Best for**: Families, swimmers
- **Rent**: Limited availability

### Benirràs
- **Vibe**: Bohemian beach, Sunday ritual
- **Pros**: Famous drum circle, beautiful bay, hippie soul
- **Cons**: Parking nightmare Sundays, limited facilities
- **Best for**: Sunset worshippers, hippie culture
- **Rent**: Nearby fincas €1,500-3,000/month

### Na Xamena Area
- **Vibe**: Dramatic cliffs, remote luxury
- **Pros**: Hacienda Na Xamena hotel, stunning views
- **Cons**: Very isolated, hotel or nothing
- **Best for**: Romantic escapes, spa retreats

## North Beaches

### Must-Visit

| Beach | Character | Best For |
|-------|-----------|----------|
| **Benirràs** | Bohemian, drums, sunset | Sunday sunset experience |
| **Portinatx (3 coves)** | Family-friendly, calm | Swimming, snorkeling |
| **Puerto San Miguel** | Sheltered bay | Families, calm water |
| **Cala Xarraca** | Natural, mud baths | Nature therapy |
| **Cala d'en Serra** | Remote, ruins | Adventure, photography |
| **S'Illot des Renclí** | Rocky pools, off-grid | Escape everything |

### Hidden Gems
- **Cala d'en Serra**: Abandoned hotel ruins, turquoise water, challenging access
- **Pou des Lleó**: Rocky platforms, natural pools, very quiet
- **Es Portitxol**: Small cove near San Miguel, local secret

## Practical Info

### Getting Around
- **Car**: Absolutely essential. No real alternative.
- **Roads**: Winding, sometimes unpaved to beaches
- **Taxi**: Available but expensive (€40+ to clubs)
- **Bus**: Extremely limited
- **Cycling**: Challenging terrain but beautiful

### Nightlife
Essentially none. This is the anti-club zone.

**What exists:**
- Village bars (local Spanish bars, close early)
- Hotel bars (Hacienda Na Xamena has a nice one)
- Benirràs Sunday sunset (nature's nightclub)

**Getting to clubs:**
- Taxi to Ibiza Town/Playa d'en Bossa: €40-50
- Not practical for regular clubbing; plan to stay south on club nights

### Dining

**San Juan Area**
- **Can Caus**: Farm restaurant, traditional, sunset views
- **El Carmen**: Village bar with food
- **Wild Beets**: Health food, hippie favorite

**Near Benirràs**
- **Can Domingo**: Excellent Mediterranean, farm-to-table vibes
- **Utopía**: Beach bar restaurant at Benirràs

**Portinatx**
- Several beach restaurants, seasonal
- Hotel restaurants

**Special Mentions**
- **Can Mimosa**: Interior, farm-to-table, beautiful gardens
- **La Paloma**: San Lorenzo area, famous booking required

### Services
- **Supermarkets**: Small in villages, limited selection
- **Stock up**: In Santa Eulalia or Ibiza Town before heading north
- **Medical**: Nearest hospital is Can Misses (30+ min)
- **ATMs**: Limited; bring cash

## Living Here

### Pros
- Nature immersion (pine forests, coves, silence)
- Spiritual/wellness scene (retreats, yoga)
- Authentic community
- Escape tourist masses
- Beautiful for hiking, outdoor life
- Affordable compared to south

### Cons
- Car essential for everything
- Far from clubs, restaurants, services
- Winters can feel isolated
- Limited socializing options
- Some areas unpaved/challenging

### Best For
- Wellness retreats
- Nature lovers
- Writers, artists, remote workers
- Long-term residents
- Families wanting peace
- Escape from tourism

### Avoid If
- You want nightlife access
- You don't drive
- You need regular services
- You want beach convenience (many are drive + walk)
- You prefer bustling social scenes

## Wellness & Retreats

The north is Ibiza's wellness capital:

**Retreat Centers**
- Various fincas host yoga retreats
- Search: Retreat Guru, BookYogaRetreats
- Peak season: May and October (weather perfect, fewer tourists)

**Drop-in Options**
- Check Facebook groups for weekly classes
- Hotels like Six Senses offer day packages

**Vibe**
- Meditation, yoga, breathwork, plant medicine (underground)
- Health-conscious community
- Organic food focus

## Insider Tips

1. **Sunday Benirràs**: Arrive by 16:00 for parking. Drums start 2 hours before sunset. Bring picnic and wine.

2. **Cala Xarraca mud**: The natural mud on the rocks is genuinely good for skin. Coat yourself, let it dry, wash off.

3. **San Juan Sunday market**: More local than Las Dalias, great produce, hippie vendors, authentic vibe.

4. **Can Marça caves**: Touristy but genuinely impressive. Good for hot afternoons.

5. **Stock your kitchen**: Limited restaurant options means cooking more. The positive: great produce at markets.

6. **Winter here**: Magical but isolated. Perfect for writing a novel, not for social life.

7. **Es Vedrà energy vs. North**: Many believe Ibiza's spiritual energy concentrates in the north (San Juan, Benirràs) as much as Es Vedrà.
