# Ibiza Town (Eivissa)

## Overview

The historic heart of the island. Dalt Vila (the walled old town) is UNESCO World Heritage. The port and marina areas buzz with restaurants, bars, and the legendary Pacha. This is where culture meets nightlife.

## Sub-Areas

### Dalt Vila (Old Town)
- **Vibe**: Historic, cultural, romantic
- **Pros**: UNESCO site, beautiful architecture, restaurants with views, peaceful
- **Cons**: Uphill walking, limited parking, some tourist trap restaurants
- **Best for**: History lovers, couples, photographers
- **Rent**: €2,500-4,000/month (apartments rare, mostly short-term)

### La Marina
- **Vibe**: Lively port area, tourist central
- **Pros**: Restaurants, shopping, nightlife, ferry terminal
- **Cons**: Touristy, can be loud, cruise ship crowds
- **Best for**: First-timers, people-watching, convenience
- **Rent**: €2,000-3,500/month

### Sa Penya
- **Vibe**: Bohemian, edgy, LGBTQ+ friendly
- **Pros**: Authentic bars, character, gateway to Dalt Vila
- **Cons**: Can feel rough at night, very narrow streets
- **Best for**: Bar-hoppers, LGBTQ+ community
- **Rent**: €1,500-2,500/month (often short-term only)

### Figueretas
- **Vibe**: Residential beach area
- **Pros**: Own beach, walkable to town center, local feel
- **Cons**: Beach not the best, some older hotels
- **Best for**: Budget option near town, longer stays
- **Rent**: €1,400-2,200/month

### Talamanca
- **Vibe**: Upscale residential, calm bay
- **Pros**: Beautiful bay, calm water, walkable to town, good restaurants
- **Cons**: Limited nightlife, fewer shops
- **Best for**: Families, couples wanting calm + access
- **Rent**: €1,800-3,000/month

### Marina Botafoch / Paseo Marítimo
- **Vibe**: Luxury, yachts, glamour
- **Pros**: Designer shops, high-end dining, marina views, near Pacha
- **Cons**: Expensive everything, limited beaches
- **Best for**: Luxury seekers, yacht enthusiasts, Pacha regulars
- **Rent**: €3,000-6,000+/month

## Practical Info

### Getting Around
- **Walking**: Feasible for most of Ibiza Town proper
- **Parking**: Extremely difficult. Use public garages (€15-25/day) or park outside town
- **Taxi**: To beaches, other towns, clubs (except Pacha = walking distance)
- **Bus**: Terminal in town; connections to all areas

### Beaches
| Beach | Distance | Notes |
|-------|----------|-------|
| Talamanca | 5 min taxi | Calm bay, sunbeds available |
| Figueretas | 5 min walk (from center) | Town beach, convenient |
| Playa d'en Bossa | 10 min taxi | Long beach, party scene |
| Ses Salines | 15 min taxi | Beautiful, natural, famous |

### Nightlife
- **Pacha**: Walking distance from port
- **Lío**: Cabaret dinner-club, Marina Botafoch
- **Heart Ibiza**: Cirque du Soleil style dinner-show (when open)
- **Port bars**: Sa Penya area, gay-friendly bars
- **Other clubs**: Taxi required (Amnesia €15, Hï €15, DC-10 €10)

### Dining Highlights

**Dalt Vila**
- **La Oliva**: French-Med, romantic terrace
- **S'Escalinata**: Terrace views, good for drinks/tapas
- **El Olivo**: Fine dining, Cathedral views

**Marina/Port**
- **Croissant Show**: Breakfast/brunch institution
- **Can Pujol**: Seafood by the port
- **La Brasa**: Meat and grill, local favorite

**Talamanca**
- **El Chiringuito**: Beach restaurant
- **Talamanca Beach Restaurant**: Upscale beachfront
- **Nobu**: Hotel restaurant, Japanese-Mediterranean

**Marina Botafoch**
- **Casa Colonial**: Sunday brunch favorite
- **STK**: Steakhouse, see-and-be-seen
- **Various high-end**: Italian, sushi, international

### Services
- **Supermarkets**: Eroski (larger) and small minimarts throughout
- **Banks**: All major Spanish banks in center
- **Medical**: Hospital Can Misses (15 min), pharmacies throughout
- **Gym**: Several options including hotels with day passes
- **Coworking**: Limited; some cafés work, or try Ibiza Town hotels

## Living Here

### Pros
- Cultural richness (Dalt Vila, museums, galleries)
- Restaurant scene (best concentration on island)
- Walk to Pacha
- Ferry terminal (Formentera day trips easy)
- Year-round life (doesn't close in winter)

### Cons
- Most expensive area
- Parking is a daily battle
- Beaches require taxi/transport
- Can be crowded with tourists
- Noise in summer (marina area)

### Best For
- Culture + nightlife seekers
- Foodies
- Digital nomads wanting city energy
- Short-term visitors wanting everything close
- LGBTQ+ visitors (welcoming scene)

### Avoid If
- You want beach at your doorstep
- You need a car daily (parking nightmare)
- You prefer quiet residential life
- Budget is a major concern

## Insider Tips

1. **Park outside, walk in**: Use outer parking and enjoy the walk. Fighting for center spots wastes hours.

2. **Dalt Vila at night**: During day it's crowded; at sunset/night, it's magical and empty.

3. **Restaurant reservations**: Book ahead for waterfront tables, especially sunset times.

4. **Morning market**: Mercat Vell (old market building) for fresh produce.

5. **Sunday in off-season**: Town shuts down; plan accordingly.

6. **Hidden squares**: Explore beyond main tourist routes in Dalt Vila for quiet terraces.
