# Visas and Residency (Ibiza / Spain)

## Scope

Ibiza follows Spanish and Schengen immigration law. For stays over 90 days, do not rely on tourist assumptions.

## Core Logic

1. Short stay for most non-EU nationals: 90 days in any rolling 180 days across Schengen.
2. EU/EEA/Swiss citizens can live and work in Spain, but must complete local registration steps for longer stays.
3. Non-EU citizens need the correct national visa or residence permit before long stays or work.

## Schengen Short Stay

### Typical visa-exempt profile
- US, UK, Canada, Australia, New Zealand, Japan, and several other nationalities can usually enter visa-free for short stays.
- Maximum stay remains 90/180 unless a specific visa or permit is granted.

### Nationals requiring short-stay visa
- Some nationalities must obtain a Schengen visa before travel.
- The exact list can change; verify against official EU/Spanish consular pages.

## ETIAS Status (Important)

- ETIAS is NOT active yet.
- Official EU communication indicates rollout is expected in Q4 2026.
- Do not tell users they need ETIAS for 2026 summer bookings unless activation is officially announced.

## Long Stay Routes (Non-EU)

### 1) Non-Lucrative Residence Visa
- For users with sufficient passive income/savings and no local employment in Spain.
- Requires private health insurance and documentation of funds.

### 2) International Telework / Digital Nomad Route
- For remote work linked mainly to non-Spanish companies/clients.
- Public UGE guidance references minimum income around 200 percent of Spanish SMI for the main applicant.
- Expect documentary burden: contract/business proof, qualification or experience, background checks, insurance.

### 3) Employee Work Route
- Requires Spanish employer sponsorship and authorization workflow.

### 4) Self-Employed Route (Autonomo)
- Requires viable activity plan, solvency, and regulatory compliance.

### 5) Study Route
- For approved academic programs with financial proof and insurance.

## Residence Operations After Arrival

Typical admin sequence for legal residents:
1. Register local address (padron) when applicable.
2. Obtain NIE/TIE process steps as required for the route.
3. Activate tax and social security obligations if working.
4. Keep renewal calendars and document copies organized.

## Tax Residency Reminder

- Spending over 183 days/year in Spain can trigger tax residency exposure.
- Digital-nomad and special tax regimes are rule-heavy; avoid promising specific rates without current specialist check.

## Frequent Mistakes

- Overstaying 90/180 while assuming island-only counting.
- Working with tourist status.
- Treating ETIAS as already active.
- Ignoring time needed for consular appointments and apostilles.
- Assuming a friend/agency claim is legally sufficient without official source check.

## What to Verify Before User Commits Money

- Official Spanish consulate requirements for user's nationality.
- Current UGE criteria for telework route.
- Current ETIAS activation status.
- Processing timelines against planned arrival date.

## Primary Sources

- ETIAS official updates: https://travel-europe.europa.eu/etias_en
- Schengen short stay overview: https://travel-europe.europa.eu/etias/who-should-apply_en
- Spain UGE telework portal: https://www.inclusion.gob.es/web/unidadgrandesempresas/autorizacion-de-residencia-para-teletrabajadores-de-caracter-internacional-ley-28-2022-
- Spain foreign affairs visa information: https://www.exteriores.gob.es/en/ServiciosAlCiudadano/Paginas/Servicios-consulares.aspx
