# Local Transport in Ibiza

## Decision Rule

Choose transport by base zone and schedule intensity, not by distance alone. Ibiza is small on map, but congestion and timing windows can break plans.

## Main Modes

| Mode | Best Use | Limits |
|---|---|---|
| Rental car | Multi-beach days, families, north/interior plans | Parking stress, peak congestion |
| Scooter | Experienced riders with light gear | Safety risk, weather exposure |
| Taxi | Night returns, point-to-point convenience | High-demand waits and surge windows |
| Bus | Budget town-to-town movement | Limited frequency/coverage for some routes |
| Walking | Inside compact zones | Not valid for most cross-island plans |

## Current Mobility Pressure

- Ibiza Airport closed 2025 with 9,138,224 passengers and 85,086 flights (AENA).
- High seasonal inflow is directly visible in road pressure and parking scarcity.

## Summer Vehicle Controls (Official Context)

Consell de Ibiza announced summer vehicle restrictions with 2025 figures such as:
- Around 20,168 daily vehicle cap for non-residents.
- Around 16,000 rental vehicles in operation with around 4,108 quota for tourists arriving by ferry.

Operational implication: if user plans to bring a non-resident vehicle by ferry, verify current permit requirements before purchase/booking.

## Car Rental Tactics

1. Book early for Jun-Sep.
2. Prefer full insurance or a clear excess strategy.
3. Validate parking plan before locking accommodation.
4. Avoid fragile schedules with multiple opposite-coast jumps in one day.

## Taxi Reality

- Reliable for specific routes, but peak windows can create long waits.
- For big nights, pre-book where possible and define fallback pickup points.
- Return logistics (04:00-07:00) are where many itineraries fail.

## Bus Reality

- Useful for simple corridor movement (airport-town-main areas).
- Less effective for remote coves or late-night precision timing.
- Always check seasonal timetable updates before committing.

## Safety Priorities

- Do not combine intoxication and driving/scooters.
- Assume narrow roads, limited lighting in some stretches, and mixed driver quality.
- For inexperienced riders, default to car/taxi/bus mix instead of scooter-heavy plans.

## Practical Planning Pattern

- Base in one zone.
- Group activities by geographic cluster.
- Reserve transport buffers for parking and exit traffic.
- Keep one low-mobility backup activity daily.

## Sources

- AENA traffic dashboard: https://www.aena.es/es/estadisticas/trafico-aereo.html
- AENA Ibiza airport page: https://www.aena.es/es/ibiza.html
- Ibiza official mobility restrictions summary: https://www.ibiza.travel/en/traffic-restrictions-and-other-actions-for-a-more-sustainable-ibiza/
