# Ibiza Research Sources (2025-2026)

> Last reviewed: March 2026

This file lists key sources used to build the Ibiza skill. Re-check legal and pricing items before final user recommendations.

## Official Transport and Mobility

| Topic | Source |
|---|---|
| AENA air traffic statistics | https://www.aena.es/es/estadisticas/trafico-aereo.html |
| AENA Ibiza airport page | https://www.aena.es/es/ibiza.html |
| Ibiza traffic restrictions overview (official tourism portal) | https://www.ibiza.travel/en/traffic-restrictions-and-other-actions-for-a-more-sustainable-ibiza/ |
| Ibiza transport and airport practical info | https://www.ibiza.travel/en/to-and-around-ibiza/ |

## Tourism, Local Government, and Context

| Topic | Source |
|---|---|
| Ibiza official tourism portal (home) | https://www.ibiza.travel/en/ |
| Consell Insular d'Eivissa (institutional portal) | https://www.conselldeivissa.es/ |
| Balearic tourism portal | https://www.illesbalears.travel/en |
| Ibiza and Formentera Preservation (mobility/environment context) | https://ibizapreservation.org/ |

## Legal and Tax

| Topic | Source |
|---|---|
| Balearic sustainable tourism tax legal text (BOE) | https://www.boe.es/buscar/act.php?id=BOE-A-2016-3744 |
| ETIAS official portal | https://travel-europe.europa.eu/etias_en |
| ETIAS launch update (expected Q4 2026) | https://travel-europe.europa.eu/etias/how-it-works_en |
| Schengen/ETIAS who needs authorization overview | https://travel-europe.europa.eu/etias/who-should-apply_en |
| Spain UGE telework route (Law 28/2022) | https://www.inclusion.gob.es/web/unidadgrandesempresas/autorizacion-de-residencia-para-teletrabajadores-de-caracter-internacional-ley-28-2022- |
| Spain consular services hub | https://www.exteriores.gob.es/en/ServiciosAlCiudadano/Paginas/Servicios-consulares.aspx |

## Cost, Housing, and Market Benchmarks

| Topic | Source |
|---|---|
| idealista rent index (Eivissa) | https://www.idealista.com/sala-de-prensa/informes-precio-vivienda/alquiler/baleares/eivissa-illes/ |
| Numbeo cost of living (Ibiza) | https://www.numbeo.com/cost-of-living/in/Ibiza |
| Numbeo rent (Ibiza) | https://www.numbeo.com/property-investment/in/Ibiza |

## Health and Safety

| Topic | Source |
|---|---|
| IB-Salut (Balearic health service) | https://www.ibsalut.es/ |
| Hospital Can Misses | https://www.hospitalcanmisses.es/ |
| US travel advisory (Spain) | https://travel.state.gov/content/travel/en/traveladvisories/traveladvisories/spain-travel-advisory.html |
| UK FCDO travel advice (Spain) | https://www.gov.uk/foreign-travel-advice/spain |

## Climate and Weather

| Topic | Source |
|---|---|
| AEMET weather agency | https://www.aemet.es/en/portada |
| Ibiza climate reference | https://weather-and-climate.com/average-monthly-Rainfall-Temperature-Sunshine,Ibiza,Spain |

## Freshness Rules

1. Visa and residency requirements: verify on official government pages before user commits travel or relocation.
2. ETIAS: confirm activation status on official EU portal (not blogs).
3. Rent and cost guidance: provide ranges and month/year context.
4. Mobility restrictions: verify current summer rule set before advising ferry-vehicle plans.
5. Healthcare and emergency details: prioritize official providers and public services.
