# Seasonal Work in Ibiza

## The Season

Main season: May to October
- **Peak hiring**: March-April
- **Peak work**: July-August
- **Wind down**: September-October
- **Off-season**: Limited opportunities

## Types of Work

### Hospitality

**Clubs & Bars**
- Bartender: €1,500-2,500/month + tips
- Barback: €1,200-1,800/month
- Promoter: Commission-based
- Security: €1,500-2,500/month
- DJ (regular): €500-3,000/night
- Dancer: €100-500/night

**Hotels**
- Reception: €1,200-1,800/month
- Housekeeping: €1,000-1,500/month
- Restaurant service: €1,200-2,000/month
- Kitchen: €1,200-2,200/month
- Spa: €1,400-2,000/month

**Restaurants/Beach Clubs**
- Server: €1,200-2,000/month + tips
- Runner: €1,000-1,500/month
- Host: €1,200-1,800/month
- Kitchen porter: €1,000-1,500/month
- Chef: €2,000-4,000/month

### Boats & Water

**Yacht Industry**
- Deckhand: €2,000-3,500/month
- Steward/ess: €2,500-4,000/month
- Chef: €3,500-6,000/month
- Captain: €5,000-15,000/month
- Engineer: €3,500-6,000/month

*Requires qualifications (STCW, ENG1, etc.)*

**Beach Services**
- Sunbed attendant: €1,000-1,500/month
- Water sports: €1,200-2,000/month
- Lifeguard: €1,400-1,800/month

### Retail & Services

- Shop assistant: €1,000-1,500/month
- Hairdresser: €1,200-2,500/month
- Massage/spa: €1,500-3,000/month (commission)
- Photography: Variable
- Tattoo artist: Commission

### Childcare & Domestic

- Nanny: €1,500-3,000/month
- Au pair: €300-500/month + room/board
- Cleaner: €12-20/hour
- Villa management: €2,000-4,000/month

### Creative & Tech

- Graphic design: Freelance rates
- Photography: Event-based
- Video/content: Freelance
- Social media: €1,500-3,000/month
- DJ (established): €1,000-10,000/night

## Finding Work

### Before Arriving

**Online**
- Facebook: "Ibiza Jobs", "Ibiza Trabajo", "Ibiza Seasonal Workers"
- Indeed Spain
- InfoJobs
- LinkedIn (professional roles)

**Timing**
- Start looking: February-March
- Apply: March-April
- Arrive: April-early May
- Late starters: Harder but possible

### On the Ground

**CV Distribution**
- Walk around with CVs
- Dress appropriately
- Go to establishments directly
- Ask for manager
- Best time: 11am-1pm or 5pm-7pm (not during service)

**Networking**
- Other workers refer each other
- Bars where workers hang out
- Staff parties
- Be present and pleasant

### What Employers Want

**Experience**
- Previous hospitality experience valued
- Ibiza experience = gold
- References from island employers

**Languages**
- Spanish: Essential for many roles
- English: Essential for tourist roles
- German: Valuable (big tourist group)
- Other EU languages: Bonus

**Presentation**
- Clean, professional
- Appropriate for role
- Friendly, energetic

**Availability**
- Full season preferred
- Flexibility on hours
- Short-term = harder to place

## Legal Requirements

### EU Citizens
- Work freely
- Get NIE (tax number)
- Empadronamiento (registration)
- Social security number

### Non-EU Citizens
- Work visa required
- Employer sponsorship needed
- Limited options
- Student visa: 20h/week max

### Contracts
- Demand written contract
- Temporary contracts common
- Know your rights
- Spanish labor law protects workers

### Pay
- Monthly salary (usually)
- Overtime regulations
- Tips: Variable (sometimes pooled)
- Cash-in-hand: Illegal (though happens)

## Accommodation Challenge

### The Reality
- Housing shortage critical
- Workers struggle to find accommodation
- Some sleep in cars/tents (illegal but real)
- Rents can consume 50%+ of salary

### Solutions

**Staff Housing**
- Some hotels provide
- Clubs rarely
- Restaurants rarely
- Ask in interview

**Shared Housing**
- Most common solution
- €400-800/month for room
- Multiple workers per room sometimes
- Start looking before arriving

**Vehicle Living**
- Some workers do this
- Not legal
- Challenging
- Only as last resort

### Tips
- Secure housing before confirming job if possible
- Accept shared situation initially
- Upgrade once established
- Off-season: Much easier

## Survival Tips

### Money
- Season costs: High (accommodation, transport, going out)
- Save: Try to save 30%+ of earnings
- Cash flow: First month tight (deposit, settling)
- Send home: If possible

### Health
- Long hours (10-14h shifts common)
- Late nights (clubs end 6am+)
- Take care of yourself
- Don't burn out in June

### Social
- Community forms fast
- Other seasonal workers become family
- Connections last years
- Don't isolate

### Exit Strategy
- Season ends: What then?
- Save for winter
- Another season elsewhere?
- Return home?
- Plan ahead

## Typical Season Arc

**April-May**
- Training, settling in
- Learning the island
- Building routines
- Quiet before storm

**June**
- Ramping up
- Getting busy
- Finding rhythm
- Energy still fresh

**July-August**
- Full madness
- Maximum hours
- Maximum money
- Maximum exhaustion

**September**
- Starting to wind down
- Staff leaving
- Still busy but easing
- Closing parties

**October**
- Last events
- Saying goodbyes
- Wrapping up
- Decision time (stay or go?)

## Beyond First Season

**Returning Workers**
- Better positions
- Better pay
- Housing easier (contacts)
- Less stressful

**Year-Round**
- Some transition to off-season roles
- Different vibe entirely
- Lower income
- More sustainable pace

**Moving Up**
- Management positions
- Own business eventually
- Some stay permanently
- The island keeps people
