# Safety & Legal Guide

## General Safety

Ibiza is generally very safe. Violent crime is rare. Main concerns are petty theft and party-related incidents.

## Crime & Theft

### Common Issues

**Pickpocketing**
- Where: Crowded clubs, beaches, markets
- Prevention: Don't bring valuables to beach; use hotel safe; front pockets/money belt

**Car Break-ins**
- Where: Beach parking areas, isolated spots
- Prevention: Never leave valuables visible; use trunk; take everything important

**Beach Theft**
- Where: All beaches when swimming
- Prevention: Don't bring valuables; take turns watching stuff; waterproof pouch for basics

**Rental Scams**
- What: Fake listings, key-money fraud
- Prevention: Use reputable platforms; never pay before seeing; verify ownership

### Reporting Crime
- **Emergency**: 112
- **Police (non-emergency)**: 091 (National), 092 (Local)
- **Tourist police**: Stations in main areas (summer)

## Drugs

### Legal Reality
Spain has complex drug laws:
- **Personal use**: Decriminalized (not legal) — small amounts for personal use not prosecuted
- **Public use**: Fines for consumption in public
- **Sale/trafficking**: Illegal, serious penalties
- **Driving under influence**: Illegal, severe consequences

### Club Policy
- All clubs: Zero tolerance
- Security searches at entry
- Caught = ejected + banned
- Some clubs share ban lists

### Real Talk
- Drugs are present in Ibiza's party scene
- Quality/purity varies wildly
- Deaths occur each season (usually combinations)
- If you choose to use: test kits, start low, don't mix, stay hydrated
- Emergency services are experienced and non-judgmental

## Alcohol

### Laws
- Legal drinking age: 18
- Public drinking: Restricted in many areas
- Driving limit: 0.5 BAC (0.3 for new drivers)
- DUI: Serious — fines, license suspension, potential jail

### Safety
- Pace yourself (long nights)
- Alternate with water
- Eat before drinking
- Watch drinks being poured
- Don't accept drinks from strangers
- Know your limits (heat + dancing = dehydration)

## Beach Safety

### Swimming
- Most beaches: Safe, calm Mediterranean
- Some rocky entries: Water shoes help
- Currents: Rare but respect flags
- Lifeguards: Major beaches only (summer)

### Sun
- UV very high in summer
- Sunscreen: Reapply every 2 hours
- Seek shade: 12:00-16:00 peak
- Hydrate constantly
- Heat exhaustion: Real risk

### Cliff Jumping
- Popular at Punta Galera and others
- Accidents happen every season
- Check depth carefully
- Don't jump drunk
- Not recommended honestly

## Road Safety

### Statistics
Ibiza has high accident rate per capita:
- Tourists unfamiliar with roads
- Scooter crashes common
- Alcohol involvement
- Winding roads + speed

### Tips
- Rent smallest car that works (easier on narrow roads)
- Avoid scooter if inexperienced
- Never drink and drive (checkpoints common)
- Roads to beaches: Take slowly
- Night driving: Extra care (unlit roads)

### If Accident
1. Don't move vehicles if injuries
2. Call 112 for serious
3. Exchange insurance info
4. Document with photos
5. Report to rental company

## Health Emergencies

### Hospitals
- **Hospital Can Misses** (Ibiza Town): Main public hospital
- **Clínica Nuestra Señora del Rosario**: Private
- **Centro de Salud**: Health centers in each town

### Emergency
- **112**: All emergencies
- **061**: Medical emergency
- Ambulance response good

### Common Issues Treated
- Dehydration
- Sunburn/heat exhaustion
- Minor injuries
- "Party aftermath"
- Jellyfish stings

## Legal Awareness

### Things That Will Get You in Trouble

**Noise**
- Fines after 23:00 in residential areas
- Villa parties: €10,000+ fines possible
- Neighbors will call police

**Photography**
- Always ask before photographing people
- Respect privacy at clubs
- Some venues prohibit phones

**Airbnb/Rentals**
- Unlicensed tourist rentals illegal
- Owners face €40,000+ fines
- Check for ETV number if concerned

**Nudity**
- Designated beaches only
- Not in town/public areas
- Topless: Fine at beaches, pools

**Balconing**
- Jumping between balconies
- Illegal and incredibly dangerous
- Deaths and injuries every year
- Hotels will evict immediately

### LGBTQ+ Safety
- Ibiza is very LGBTQ+ friendly
- Open scene, especially Ibiza Town
- Spain has strong protections
- PDA generally fine
- Es Cavallet: Gay beach

## Scams to Know

### Common Scams

**Fake tickets**
- Buy from official sources only
- Street sellers: Risky

**Dodgy promoters**
- Promises of "free entry"
- May be legit, may not be
- Use judgment

**Taxi overcharging**
- Agree price first for long rides
- Check meter is running
- Know approximate fares

**Rental deposits**
- Document everything on check-in
- Video walk-through
- Know your rights

**Boat party quality**
- Research operator
- Check reviews
- Cheapest not always best

## Emergency Contacts

| Service | Number |
|---------|--------|
| All emergencies | 112 |
| Police (National) | 091 |
| Police (Local) | 092 |
| Medical emergency | 061 |
| Fire | 080 |
| Coast guard | 900 202 202 |
| Hospital Can Misses | +34 971 397 000 |

## Travel Insurance

**Strongly recommended** covering:
- Medical (especially party-related)
- Theft
- Trip cancellation
- Adventure activities (if applicable)

EU citizens: EHIC/GHIC covers public healthcare
Non-EU: Private insurance essential
