# Housing & Rentals in Ibiza

## The Housing Crisis

Ibiza has a severe housing shortage. Understanding this is essential:
- Prices doubled in 5 years
- 90% of housing goes to tourism
- Workers struggle to find accommodation
- Protests and tension growing
- Legislative changes ongoing

## Rental Market

### Types of Rentals

**Short-Term Tourist (1-30 days)**
- Airbnb, Booking, etc.
- Must have ETV license
- Summer: €150-500+/night
- Easier to find but expensive

**Medium-Term (1-6 months)**
- Hardest to find
- Landlords prefer tourist rates in summer
- Off-season: More available
- Often unlicensed (legal grey area)

**Long-Term (11+ months)**
- Spanish tenant protection applies
- Better rates
- Harder to find
- Landlords prefer flexibility

### Prices by Area (Monthly)

**Summer (Peak)**

| Area | Room | 1BR | 2BR |
|------|------|-----|-----|
| Ibiza Town | €800-1,200 | €2,000-3,500 | €2,500-4,500 |
| Playa d'en Bossa | €700-1,000 | €1,500-2,800 | €2,000-4,000 |
| San Antonio | €600-900 | €1,200-2,000 | €1,800-3,000 |
| Santa Eulalia | €700-1,000 | €1,400-2,500 | €2,000-3,500 |
| Interior | €500-800 | €1,000-1,800 | €1,500-2,500 |
| North | €600-900 | €1,300-2,500 | €1,800-3,000 |

**Winter (Off-Season)**
Expect 40-60% less across all areas.

### Where to Search

**Facebook Groups (Most Important)**
- "Ibiza Housing"
- "Ibiza Jobs & Housing"
- "Viviendas Ibiza"
- "Alquiler Ibiza"
- Check daily; good listings go fast

**Websites**
- Idealista (Spanish Rightmove)
- Fotocasa
- Habitaclia
- Milanuncios (classifieds)

**Agencies**
- Premium service, fees (1 month)
- Better for quality long-term
- Examples: Ibiza Agents, Kühn & Partner

**Word of Mouth**
- Tell everyone you're looking
- Bars, cafés, workplaces
- Expat community tight-knit

### Timing

**When to Look**

| When | Availability | Competition |
|------|--------------|-------------|
| January-February | Best | Low |
| March-April | Good | Medium |
| May | Moderate | High |
| June-August | Worst | Extreme |
| September | Improving | Medium |
| October-December | Good | Low |

**For Summer Stay**
- Start looking: January/February
- Be ready to commit fast
- Have deposit ready

## Renting Process

### What You'll Need
- Passport/ID
- Proof of income (payslips, bank statements)
- Spanish NIE (for long-term)
- Deposit (1-2 months)
- Sometimes references

### Standard Terms
- Deposit: 1-2 months rent
- Notice: 1 month (varies)
- Utilities: Usually tenant pays
- Agency fee: 1 month (if used)

### Red Flags
- No viewing before payment
- Pressure to pay immediately
- No written contract
- Price too good to be true
- No proof of ownership
- Request for unusual payment methods

### Contract Essentials
Get in writing:
- Exact rent amount
- Deposit and return conditions
- What's included (utilities, WiFi, etc.)
- Notice period
- Inventory of contents
- Contact for maintenance

## For Seasonal Workers

### Reality
- Many workers share rooms
- Some sleep in cars/tents (illegal but happens)
- Staff accommodation: Some jobs include housing
- Start looking before arriving

### Tips
- Accept shared housing initially
- Upgrade once established
- Network at work for leads
- Consider commuting from cheaper areas

### Staff Housing
Some employers provide:
- Hotels (staff quarters)
- Clubs (sometimes)
- Restaurants (rarely)
Always ask in job interview.

## Buying Property

### Market Overview
- Prices: All-time highs
- Foreign buyers: Common (Germans, British)
- Golden visa: €500,000 minimum investment
- Yield: 4-8% rental return

### Price Ranges

| Type | Typical Price |
|------|---------------|
| Studio | €180,000-300,000 |
| 1BR apartment | €280,000-500,000 |
| 2BR apartment | €400,000-700,000 |
| Townhouse | €500,000-1,000,000 |
| Villa | €1,000,000-10,000,000+ |

### Process
1. Find property (agent or direct)
2. Make offer
3. Reserve with deposit (€3,000-10,000)
4. Due diligence (lawyer essential)
5. Sign private contract (10% deposit)
6. Complete at notary
7. Register ownership

### Costs
- Agent fee: 5% (usually seller pays)
- Notary: 0.5-1%
- Registry: 0.5-1%
- Transfer tax: 8-10%
- Legal fees: 1-2%
- **Total extra: ~12-15% of purchase price**

### Financing
- Spanish mortgages available to foreigners
- Typically 60-70% LTV
- Higher rates than local buyers
- Proof of income required

## Legal Considerations

### Tourist Rental License (ETV)
- Required for any rental under 1 month
- New licenses essentially unavailable
- Fines for unlicensed: €40,000+
- Check license before renting to tourists

### Long-Term Tenant Rights
Spanish law protects long-term tenants:
- Minimum 5-year extensions (individuals) or 7-year (companies)
- Limited rent increases
- Harder to evict
- Know your rights

### Deposit Return
- Landlord has 1 month to return
- Can deduct damages (with proof)
- Document condition on arrival (video/photos)
- Normal wear is expected
