# Healthcare in Ibiza

## System Overview

Spain has excellent public healthcare. Ibiza, as part of Spain, benefits from this system, though with island-specific limitations.

## Emergency Care

### Emergency Numbers
- **112**: All emergencies (police, fire, medical)
- **061**: Medical emergencies (Balearic Islands)

### Hospital
- **Hospital Can Misses**: Main public hospital
  - Address: Carrer de Corona, s/n, Eivissa
  - 24h emergency department
  - Full services
  - Phone: +34 971 397 000

### Emergency Rooms
- Hospital Can Misses (24h)
- Serious cases: May be transferred to Palma (Mallorca)

### Response Times
- Ambulance: Generally good (15-30 min most areas)
- North/remote: Longer
- Helicopter transfer available for serious cases

## Public Healthcare

### Who's Covered

**EU Citizens**
- EHIC/GHIC card: Emergency and necessary care
- Registered residents: Full coverage
- Must be in public system (empadronamiento + social security)

**UK Citizens (Post-Brexit)**
- UK GHIC: Emergency care only
- Residents need private or join Spanish system
- S1 form: If receiving UK pension

**Non-EU Citizens**
- Travel insurance essential
- Registered residents can join public system
- Some means-tested access available

### Accessing Public Care

**For Residents:**
1. Empadronamiento (town hall registration)
2. Social security number (if working) or register as inactive
3. SIP card (health card) from Centro de Salud
4. Choose GP
5. Referrals to specialists through GP

**Centro de Salud (Health Centers)**
- Ibiza Town
- Santa Eulalia
- San Antonio
- San José

### Services Covered
- GP consultations
- Specialist referrals
- Hospital treatment
- Emergency care
- Prescriptions (subsidized)
- Maternity care
- Mental health (limited)

### Limitations
- Wait times: Can be long for specialists
- Language: May need Spanish
- Bureaucracy: Forms, appointments
- Coverage: Not everything included

## Private Healthcare

### When to Use Private
- Speed (immediate appointments)
- English-speaking doctors
- Dental (not covered publicly)
- Specialists without referral
- Comfort and privacy

### Private Clinics

**Policlínica Nuestra Señora del Rosario**
- Main private hospital
- Full services
- English-speaking staff
- 24h emergency
- Phone: +34 971 301 916

**Various Private Clinics**
- Dental clinics throughout island
- Physiotherapy
- Specialist doctors
- Aesthetics

### Costs (Without Insurance)
| Service | Approximate Cost |
|---------|-----------------|
| GP consultation | €50-100 |
| Specialist | €80-150 |
| Dental cleaning | €50-80 |
| X-ray | €40-80 |
| Blood tests | €50-150 |
| Minor surgery | €200-500 |
| Hospital day | €500-1,000+ |

### Private Insurance

**Spanish Providers**
- Sanitas
- Adeslas
- DKV
- Asisa

**Costs:**
- Basic: €50-80/month
- Comprehensive: €100-200/month
- Age affects pricing
- Pre-existing conditions: May exclude or load

**Benefits:**
- Fast access
- English-speaking options
- No referral needed for specialists
- Private rooms

## Pharmacies (Farmacias)

### Basics
- Green cross sign
- Throughout all towns
- Many medications available without prescription
- Staff often speak English

### Opening Hours
- Regular: 9:30-13:30, 17:00-20:30 (varies)
- Farmacia de guardia: 24h duty pharmacy (rotates)
- Find duty pharmacy: Ask any pharmacy or check local press

### Useful Pharmacy Items
- Sunburn treatment (After-sun, aloe)
- Rehydration salts (Sueroral)
- Antihistamines
- Pain relief
- Basic antibiotics (pharmacist discretion)
- Morning after pill (available)
- Contraception

### Prescription Medicines
- Spanish prescriptions valid
- EU prescriptions mostly valid
- Subsidized if in public system
- Full price if private/tourist

## Specific Situations

### Sun & Heat
**Prevention:**
- SPF 30-50 sunscreen
- Reapply every 2 hours
- Avoid 12:00-16:00 peak
- Hydrate constantly
- Hat and shade

**Treatment:**
- After-sun lotion
- Cool compresses
- Ibuprofen for inflammation
- Seek medical help if: Severe blistering, fever, vomiting

### Hangovers & "Party Recovery"
**Pharmacy helps:**
- Electrolyte solutions
- Vitamin B complex
- Paracetamol (not if drinking more)
- Activated charcoal
- Anti-nausea

**Serious signs (seek help):**
- Confusion
- Severe vomiting
- Chest pain
- Difficulty breathing

### Water Safety
**Jellyfish stings:**
- Remove tentacles (carefully)
- Rinse with seawater (not fresh water)
- Don't urinate on it (myth)
- Seek help if: Allergic reaction, sting to face

**Sea urchins:**
- Remove spines carefully
- Hot water helps
- Pharmacy antiseptic

### Travel Vaccinations
No special vaccinations required for Ibiza.

Standard recommendations:
- Routine vaccinations up to date
- Hepatitis A (if concerned)
- COVID-19 (current guidance)

## Mental Health

### Public Services
- Centro de Salud can refer
- Long wait times
- Spanish language often
- Limited resources

### Private Options
- Various psychologists/psychiatrists
- English-speaking available
- Search: "Psicólogo Ibiza"
- €60-120/session typical

### Crisis
- 112 for immediate danger
- Teléfono de la Esperanza: 717 003 717
- Hospital Can Misses psychiatric

### Challenges
- Island isolation can affect mental health
- Seasonal workers: Burnout common
- Party culture: Potential for excess
- Know your limits

## Dental

### Not Covered Publicly
Dental care is mostly private in Spain.

### Finding a Dentist
- Multiple clinics island-wide
- English-speaking options available
- Search or ask expat community

### Costs
| Service | Approximate |
|---------|-------------|
| Checkup | €30-50 |
| Cleaning | €50-80 |
| Filling | €60-150 |
| Extraction | €80-200 |
| Root canal | €200-500 |
| Crown | €300-600 |

## Insurance Recommendations

### Short-Term Visitors
- Travel insurance essential
- Include: Medical, repatriation, activities
- Adventure sports: Check coverage
- Compare: World Nomads, SafetyWing, Allianz

### Long-Term/Residents
- EU citizens: Register in public system
- Non-EU: Private insurance strongly recommended
- Digital nomad visa: Requires insurance

### What to Look For
- Medical coverage: €100,000+ minimum
- Repatriation included
- 24h assistance line
- Direct billing if possible
- Pre-existing conditions: Check exclusions
