# Culture & History

## Historical Overview

### Ancient History
- Phoenicians founded settlement (~654 BCE)
- Named "Ibossim" (island of Bes, god of dance)
- Major trading post
- Puig des Molins: UNESCO Phoenician necropolis

### Through the Ages
- Carthaginian control
- Roman period (Ebusus)
- Vandals and Byzantines
- Moorish rule (902-1235)
- Catalan conquest (1235)
- Spanish integration

### Modern Era
- Agricultural economy (almonds, salt, fishing)
- 1960s: Hippie discovery
- 1970s-80s: Tourism develops
- 1990s: Club scene emerges
- 2000s+: Luxury destination

## UNESCO World Heritage

Ibiza has two UNESCO designations:

### Biodiversity and Culture (1999)
Includes:
- **Dalt Vila**: Fortified upper town
- **Puig des Molins**: Phoenician necropolis
- **Posidonia meadows**: Underwater seagrass
- **Sa Caleta**: Phoenician settlement

### What to Visit

**Dalt Vila**
- Walk the walls
- Cathedral at top
- Museums inside
- Best at sunset
- Free to explore

**Puig des Molins**
- Ancient burial site
- Museum with artifacts
- Guided tours available
- €3-5 entry

## Local Culture

### The Real Ibicencos

The native population has distinct identity:
- **Language**: Ibizan (variant of Catalan), plus Spanish
- **Traditions**: Music, dance, costume
- **Religion**: Catholic heritage, village churches
- **Economy**: Historically farming, fishing, salt

### Modern Reality
- Only ~25% of residents are Ibicenco
- Tourism dominates economy
- Tension between tradition and development
- Housing crisis affects locals severely
- Language preservation efforts ongoing

## Traditions & Festivals

### Ball Pagès
Traditional Ibicenco folk dance:
- Men and women in traditional costume
- Distinctive music (flute and drum)
- Courtship dance style
- Performed at festivals
- Worth seeing if you can find it

### Key Festivals

**San Juan (June 23-24)**
- Biggest local celebration
- Bonfires on beaches
- Celebration of summer solstice
- Jumping over fires tradition
- Book accommodation early

**Virgen del Carmen (July 16)**
- Patron of fishermen
- Boat processions
- Coastal towns celebrate
- Beautiful to witness

**Mare de Déu de les Neus (August 5)**
- Ibiza Town patron saint
- Local holiday
- Processions, events

**Sant Bartomeu (August 24)**
- San Antonio patron saint
- Local festivities

### Village Fiestas
Each village has its patron saint festival:
- Music, dancing, fireworks
- Local food and drink
- Authentic experience
- Check local calendars

## The Hippie Heritage

### 1960s Discovery
- Post-Franco Spain was cheap and tolerant
- Artists, musicians, dropouts arrived
- Formed communities in countryside
- Mixed with existing local culture
- Created unique "Ibiza spirit"

### Legacy Today
- Hippie markets (Las Dalias, Punta Arabí)
- Adlib fashion (white, flowing clothes)
- Wellness/spiritual scene
- Bohemian aesthetics
- Northern villages retain vibe

### Where to Experience
- **Las Dalias market**: Saturday/Thursday (summer)
- **Benirràs**: Sunday drum circle
- **San Carlos**: Original hippie village
- **Anita's Bar**: Legendary since 1970s

## Art & Music

### Music History
- Club culture from late 1980s
- Balearic Beat: Distinct sound
- Pioneer DJs: Alfredo, José Padilla
- Now: Global electronic music capital
- Many producers live here year-round

### Art Scene
- Growing gallery scene
- Ibiza Town has several galleries
- Artist studios throughout
- Photography exhibitions
- Street art increasing

### Creative Community
- Musicians, DJs, producers
- Visual artists
- Fashion designers
- Writers
- Photographers
- Attracted by light, energy, lifestyle

## Religion

### Catholic Heritage
- Churches in every village
- Distinctive white-washed architecture
- Saints' days celebrated
- Religious processions
- Respectful dress when visiting churches

### Spiritual Diversity
- Wellness/New Age community
- Various practices
- Full moon gatherings
- Es Vedrà "energy"
- Syncretic, tolerant atmosphere

## Language

### What's Spoken

**Official:**
- Spanish (Castilian): Everyone speaks
- Catalan/Ibizan: Local language

**Common:**
- English: Widely spoken (tourism)
- German: Large German community
- Italian: Common
- French: Present

### Language Tips
- Spanish appreciated everywhere
- English fine for tourism
- Learning basic Spanish helps for deeper connection
- Local Ibizan: Interesting to know exists

## Customs & Etiquette

### General
- Greetings: Two kisses (cheeks) among friends
- Timing: Spanish schedule (late lunch, late dinner)
- Dress: Conservative in villages/churches
- Noise: Respect quiet hours (23:00-8:00)

### Beach Etiquette
- Topless: Accepted everywhere
- Nudism: Designated beaches only
- Space: Don't crowd others
- Music: Keep volume reasonable
- Trash: Take it with you

### Restaurant Etiquette
- Tipping: Not obligatory, 5-10% for good service
- Timing: Lunch 14:00-16:00, dinner 21:00+
- Reservations: Essential for popular spots
- Bill: Ask for it ("la cuenta")

## Local Products

### Food
- Hierbas Ibicencas (herb liqueur)
- Flor de sal (sea salt from Ses Salines)
- Local olive oil
- Almonds
- Sobrasada (cured sausage)
- Flaó (cheese/mint tart)

### Crafts
- Adlib fashion (white clothing)
- Handmade jewelry
- Pottery
- Woven baskets
- Leather goods

### Where to Buy
- Hippie markets (authentic handmade)
- Town boutiques (Adlib)
- Supermarkets (food products)
- Local producers (oil, wine)
