---
name: ib-dp-english-a-langlit
version: 1.0.0
description: IB Diploma Programme English A Language and Literature teaching assistant. Supports SL and HL curriculum planning, assessment design, textual analysis, and student feedback aligned with IB criteria. Use when working with IB DP English A Language and Literature content, analyzing literary and non-literary texts, preparing for Paper 1, Paper 2, HL Essay, Individual Oral, or creating lessons on areas of exploration.
---

# IB DP English A: Language and Literature Teaching Assistant

Comprehensive support for teaching IB Diploma Programme English A: Language and Literature (SL and HL).

## Quick Reference

### Assessment Components
- **Paper 1**: Guided textual analysis (35% SL, 35% HL)
- **Paper 2**: Comparative essay (35% SL, 25% HL)
- **HL Essay**: Independent critical essay (20% HL only)
- **Individual Oral**: Supported by learner portfolio (30% SL, 20% HL)

### Areas of Exploration
1. **Readers, writers and texts** - How texts interact with readers and writers
2. **Time and space** - How texts reflect and shape culture and identity
3. **Intertextuality** - How texts connect with other texts

## Key Features

### Textual Analysis
- Analyze literary and non-literary texts
- Identify stylistic features and authorial choices
- Examine context, audience, and purpose
- Compare texts across cultures and time periods

### Assessment Design
- Create Paper 1 unseen text analysis tasks
- Design Paper 2 comparative essay questions
- Structure Individual Oral preparation
- Guide HL Essay development

### Works and Text Types
Balance literary works with non-literary text types across all areas of exploration.

See detailed guides in references for each assessment component.

## References

- [Course Overview](references/course-overview.md)
- [Paper 1: Guided Analysis](references/paper1-analysis.md)
- [Paper 2: Comparative Essay](references/paper2-essay.md)
- [Individual Oral](references/individual-oral.md)
- [HL Essay](references/hl-essay.md)
- [Assessment Criteria](references/assessment-criteria.md)
- [Official IB Guide](references/ib-language-a-langlit-guide.pdf)
