---
name: hyperclaw
description: Trade on Hyperliquid. Supports 228+ perps, HIP-3 equity/commodity perps (TSLA, GOLD), market scanning, sentiment analysis, Grok web/X search, and prediction market data. Commands for account status, market data, funding rates, order book, trading, and intelligence gathering.
user-invocable: true
metadata:
  openclaw:
    requires:
      env:
        - HL_ACCOUNT_ADDRESS
        - HL_SECRET_KEY
---

# HyperClaw - Hyperliquid Trading Skill

Trade on Hyperliquid via CLI. Covers native crypto perps (BTC, ETH, SOL, etc.), HIP-3 builder-deployed perps (equities, commodities, forex), market scanning, and intelligence tools.

## Setup

Run the setup script once to create a virtual environment and install dependencies:

```bash
bash {baseDir}/scripts/setup.sh
```

Then configure `.env` in the skill root directory with your Hyperliquid API credentials:

```
HL_ACCOUNT_ADDRESS=0x_your_wallet_address
HL_SECRET_KEY=0x_your_api_wallet_private_key
HL_TESTNET=false
```

Get API keys from: https://app.hyperliquid.xyz/API — use a separate API wallet, not your main wallet private key.

Optional for intelligence commands (sentiment, unlocks, devcheck, ask, search):
```
XAI_API_KEY=xai-...
```

After configuring `.env`, start the caching proxy (prevents rate limiting):

```bash
{baseDir}/scripts/.venv/bin/python {baseDir}/scripts/server.py &
```

## How to Run Commands

```bash
{baseDir}/scripts/.venv/bin/python {baseDir}/scripts/hyperliquid_tools.py <command> [args]
```

## Command Reference

### Account

| Command | Description | Example |
|---------|-------------|---------|
| `status` | Account balance, account mode, positions, PnL (handles unified/portfolio margin accounts) | `hyperliquid_tools.py status` |
| `positions` | Detailed position info (leverage, liquidation) | `hyperliquid_tools.py positions` |
| `orders` | Open orders | `hyperliquid_tools.py orders` |
| `check` | Position health check (book ratio, funding, PnL, leverage, liquidation warnings) | `hyperliquid_tools.py check` or `check --address 0x...` |
| `user-funding` | Your funding payments received/paid | `hyperliquid_tools.py user-funding --lookback 7d` |
| `portfolio` | Portfolio performance (PnL, volume by period) | `hyperliquid_tools.py portfolio` or `portfolio --address 0x...` |
| `swap` | Swap USDC ↔ HIP-3 dex collateral (USDH, USDe, USDT0, USDXL) | `hyperliquid_tools.py swap 20` or `swap 20 --token USDe` or `swap 10 --to-usdc` |

### Market Data

| Command | Description | Example |
|---------|-------------|---------|
| `price [COINS...]` | Current prices (supports HIP-3 dex prefix) | `hyperliquid_tools.py price BTC ETH xyz:TSLA` |
| `funding [COINS...]` | Funding rates (hourly + APR + signal). `--predicted` shows the estimated rate for the next hourly settlement (can still shift as mark/oracle prices move before the hour closes), with Binance/Bybit comparison (APR-normalized across different intervals). Use predicted to preview upcoming charges and confirm a funding edge isn't HL-specific. | `hyperliquid_tools.py funding BTC SOL DOGE` or `funding BTC --predicted` |
| `book COIN` | L2 order book with spread | `hyperliquid_tools.py book SOL` |
| `candles COIN` | OHLCV candlestick data with SMA | `hyperliquid_tools.py candles BTC --interval 1h --lookback 7d` |
| `funding-history COIN` | Historical funding rates with summary | `hyperliquid_tools.py funding-history BTC --lookback 24h` |
| `trades COIN` | Recent trade tape with buy/sell bias | `hyperliquid_tools.py trades BTC --limit 20` |
| `raw COIN` | Raw JSON data dump for processing | `hyperliquid_tools.py raw BTC` |

### Analysis

| Command | Description | Example |
|---------|-------------|---------|
| `analyze [COINS...]` | Comprehensive market analysis (prices, funding, OI, volume, book depth) | `hyperliquid_tools.py analyze BTC ETH SOL` |
| `scan` | Scan all perps for funding opportunities. `--sort {funding\|volume\|oi\|price-change}` outputs a single flat table sorted by the chosen metric (default: multi-section view). `--reverse` reverses sort direction. | `hyperliquid_tools.py scan --top 20 --min-volume 100000` or `scan --sort volume --top 10 --reverse` |
| `hip3 [COIN]` | HIP-3 perp data (price, spread, funding) | `hyperliquid_tools.py hip3 TSLA` |
| `hip3` | All HIP-3 dex assets | `hyperliquid_tools.py hip3` |
| `dexes` | List all HIP-3 dexes and their assets | `hyperliquid_tools.py dexes` |
| `history` | Trade history from API | `hyperliquid_tools.py history --limit 20` |

### Trading

| Command | Description | Example |
|---------|-------------|---------|
| `leverage COIN LEV` | Set leverage for an asset (persists on Hyperliquid) | `hyperliquid_tools.py leverage SOL 5` |
| `leverage COIN LEV --isolated` | Set leverage with isolated margin | `hyperliquid_tools.py leverage xyz:TSLA 3 --isolated` |
| `buy COIN SIZE` | Market buy (long) | `hyperliquid_tools.py buy SOL 0.5` |
| `buy COIN SIZE --leverage LEV` | Market buy with leverage set first | `hyperliquid_tools.py buy SOL 0.5 --leverage 5` |
| `sell COIN SIZE` | Market sell (short) | `hyperliquid_tools.py sell SOL 0.5` |
| `sell COIN SIZE --leverage LEV` | Market sell with leverage set first | `hyperliquid_tools.py sell SOL 0.5 --leverage 5` |
| `limit-buy COIN SIZE PRICE` | Limit buy order (GTC) | `hyperliquid_tools.py limit-buy SOL 1 120` |
| `limit-sell COIN SIZE PRICE` | Limit sell order (GTC) | `hyperliquid_tools.py limit-sell SOL 1 140` |
| `stop-loss COIN SIZE TRIGGER` | Stop-loss trigger (market, reduce-only) | `hyperliquid_tools.py stop-loss SOL 0.5 115` |
| `take-profit COIN SIZE TRIGGER` | Take-profit trigger (market, reduce-only) | `hyperliquid_tools.py take-profit SOL 0.5 150` |
| `close COIN` | Close entire position (supports HIP-3) | `hyperliquid_tools.py close SOL` |
| `cancel OID` | Cancel specific order | `hyperliquid_tools.py cancel 12345` |
| `cancel-all` | Cancel all open orders | `hyperliquid_tools.py cancel-all` |
| `modify-order OID PRICE` | Modify existing order price/size | `hyperliquid_tools.py modify-order 12345 130.5 --size 2` |

**Leverage:** Leverage is set per-asset on your Hyperliquid account and persists until changed. Each asset has a max leverage (e.g., BTC=40x, ETH=25x, SOL=20x). The `leverage` command and `--leverage` flag show the max and block if exceeded. Use `positions` to see current leverage on open positions. HIP-3 assets require isolated margin (`--isolated`).

### Intelligence (requires XAI_API_KEY)

| Command | Description | Example |
|---------|-------------|---------|
| `sentiment COIN` | Grok web + X/Twitter sentiment analysis | `hyperliquid_tools.py sentiment BTC` |
| `unlocks [COINS...]` | Token unlock schedules (defaults to current positions) | `hyperliquid_tools.py unlocks SOL HYPE` |
| `devcheck COIN` | Developer sentiment and exodus signals | `hyperliquid_tools.py devcheck SOL` |
| `ask QUERY` | Ask Grok a question — single API call with web + X tools, returns one blended answer. `--web` for web only, `--x` for X only. | `hyperliquid_tools.py ask "what's driving ETH price today?"` or `ask "BTC whale activity" --x` |
| `search QUERY` | Search web and X/Twitter via Grok — separate API calls per source, prints results in distinct sections for more exhaustive coverage. `--web` for web only, `--x` for X only. | `hyperliquid_tools.py search "Hyperliquid token unlock schedule"` or `search "SOL news" --web` |

### Prediction Markets

| Command | Description | Example |
|---------|-------------|---------|
| `polymarket [CATEGORY]` | Active Polymarket prediction markets | `hyperliquid_tools.py polymarket crypto` |

Categories: `crypto` (default), `btc`, `eth`, `trending`, `macro`

### HIP-3 Trading

HIP-3 assets use a dex prefix: `dex:SYMBOL`

```bash
hyperliquid_tools.py buy xyz:TSLA 1          # Buy TSLA on xyz dex
hyperliquid_tools.py sell vntl:ANTHROPIC 1   # Sell ANTHROPIC on vntl dex
hyperliquid_tools.py close xyz:GOLD          # Close GOLD position
hyperliquid_tools.py funding xyz:TSLA vntl:SPACEX km:US500
```

**Known HIP-3 dexes:** xyz (equities, commodities), vntl (private companies), flx (crypto/commodities), hyna (crypto), km (indices), abcd, cash. Use `dexes` command to discover all available dexes dynamically.

**HIP-3 differences from native perps:**
- Isolated margin only (no cross margin)
- Per-position liquidation prices
- Higher fees (2x normal)
- Thinner order books (wider spreads)
- Max leverage varies by asset (10x for most equities, 20x for commodities/metals)
- Some dexes require non-USDC collateral — swap first (see below)

**HIP-3 Collateral:** Some dexes use stablecoin collateral other than USDC (e.g. USDH, USDe, USDT0). You must swap USDC to the required collateral before trading on these dexes. Use `dexes` to check current collateral requirements — they can change.

| Collateral | Swap command |
|-----------|--------------|
| USDC | No swap needed |
| USDH | `swap <amount>` (default) |
| USDe | `swap <amount> --token USDe` |
| USDT0 | `swap <amount> --token USDT0` |
| USDXL | `swap <amount> --token USDXL` |

**Note on USDXL:** USDXL (Last USD) is not on Hyperliquid's strict list and has lower liquidity than other collateral tokens. Expect wider spreads when swapping. No HIP-3 dex currently uses USDXL as collateral, but the swap is available if needed.

To swap collateral back to USDC: `swap <amount> --to-usdc` (or `swap <amount> --token USDe --to-usdc`).

Example workflow for km:US500:
```bash
hyperliquid_tools.py swap 20                          # Swap 20 USDC → USDH
hyperliquid_tools.py leverage km:US500 10 --isolated  # Set leverage
hyperliquid_tools.py buy km:US500 0.02                # Trade
hyperliquid_tools.py close km:US500                   # Close when done
hyperliquid_tools.py swap 20 --to-usdc                # Swap USDH back to USDC
```

## Caching Proxy (Default — Start First)

Each CLI invocation cold-starts the SDK and burns ~40 API weight units just to initialize. With a 1200 weight/min IP limit, agents hit rate limits after ~30 commands. **Always start the proxy before running commands.**

**Start the proxy:**

```bash
{baseDir}/scripts/.venv/bin/python {baseDir}/scripts/server.py &
```

The `.env` file includes `HL_PROXY_URL=http://localhost:18731` by default. All read commands will route through the proxy automatically. To disable the proxy (not recommended), comment out or remove `HL_PROXY_URL` from `.env`.

**Restart the proxy** after installing or updating the skill (e.g. `git pull`, dependency changes). The proxy runs in-memory — it won't pick up code or config changes until restarted:

```bash
# Find and kill existing proxy, then restart
kill $(lsof -ti:18731) 2>/dev/null; {baseDir}/scripts/.venv/bin/python {baseDir}/scripts/server.py &
```

**Proxy endpoints:**

| Endpoint | Description |
|----------|-------------|
| `GET /health` | Check proxy status and uptime |
| `GET /cache/stats` | Cache hit/miss rates per type |
| `POST /cache/clear` | Clear cache (optional body: `{"type":"..."}` or `{"user":"0x..."}`) |

The proxy caches `/info` read responses (metadata 300s, prices 5s, user state 2s). Trading commands (`buy`, `sell`, `close`, etc.) always go directly to the real Hyperliquid API — they bypass the proxy entirely because the SDK requires the real URL for transaction signing. The proxy is a **read cache only**. Responses include `X-Cache: HIT` or `X-Cache: MISS` headers.

**Proxy env vars:**

| Variable | Default | Description |
|----------|---------|-------------|
| `HL_UPSTREAM_URL` | `https://api.hyperliquid.xyz` | Upstream API |
| `HL_PROXY_PORT` | `18731` | Proxy port |
| `HL_CACHE_WARMUP` | `true` | Pre-warm cache on startup |

## Environment Variables

| Variable | Required | Description |
|----------|----------|-------------|
| `HL_ACCOUNT_ADDRESS` | For trading/status | Hyperliquid wallet address |
| `HL_SECRET_KEY` | For trading | API wallet private key |
| `HL_TESTNET` | No | `false` for mainnet (default), `true` for testnet |
| `HL_PROXY_URL` | Recommended | Caching proxy URL (default: `http://localhost:18731`) |
| `HL_ENV_FILE` | No | Override `.env` file path. When set, loads env vars from this file instead of default `.env` discovery. Useful for wrapper scripts that route to hyperclaw from other projects. |
| `XAI_API_KEY` | For intelligence | Grok API key for sentiment/unlocks/devcheck/ask/search |

**Read-only commands** (`price`, `funding`, `book`, `scan`, `hip3`, `dexes`, `raw`, `polymarket`) work without credentials. Trading and account commands require `HL_ACCOUNT_ADDRESS` and `HL_SECRET_KEY`.

## Account Abstraction Modes

**Unified mode is recommended for API wallet trading.** In standard mode, funds are split between spot and perp clearinghouses, and API wallets cannot transfer between them. Unified mode pools all funds into a single balance, so cross-margin perps can access your full balance without manual transfers. HIP-3 dexes that require non-USDC collateral work in both modes — just use the `swap` command to convert USDC to the required collateral.

Hyperliquid accounts operate in one of several modes that affect where balances live. The `status` command auto-detects the mode and shows it as a badge (`[unified]`, `[portfolio margin]`, or `[standard]`).

| Mode | Badge | How balances work |
|------|-------|-------------------|
| **Unified** (default) | `[unified]` | Single balance per asset across all DEXes. Spot and perp share collateral. All balances appear in the spot clearinghouse. |
| **Portfolio Margin** | `[portfolio margin]` | All eligible assets (HYPE, BTC, USDH, USDC) unified into one margin calculation. Most capital-efficient. Pre-alpha. |
| **Standard** | `[standard]` | Separate balances for perps and spot on each DEX. No cross-collateralization. |
| **DEX Abstraction** | `[unified]` | Deprecated. USDC defaults to perps balance, other collateral to spot. Shown as `[unified]` since behavior is similar. |

**For position sizing, always use "Portfolio Value"** from `status`. In standard mode this equals the perp account value. In unified/portfolio margin mode it equals `perp accountValue + spot balances`, since funds can live in either clearinghouse. The "Perp Margin" sub-line (only shown for non-standard modes) is just the perp clearinghouse portion — don't use it for sizing.
