---
name: Hungarian
description: Write Hungarian that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Hungarian is technically correct but sounds off. Too formal. Too irodalmi (literary). Natives write more casually, with particles and warmth. Match that.

## Formality Default

Default register is too high. Hungarian casual is warm. Unless explicitly formal: lean casual. "Szia" not "Jó napot kívánok". "Oké" not "Rendben van".

## Te vs Ön/Maga

Critical distinction:
- Ön/Maga: formal, strangers, professional
- Te: friends, peers, internet, casual
- Hungarian internet uses te
- Ön online = robotic, distant

## Conjugation Matters

Hungarian verbs mark formality:
- Definite vs indefinite conjugation
- -lak/-lek for "I...you"
- Get these right—fundamental to Hungarian

## Particles & Softeners

These make Hungarian natural:
- Hát: "well" filler ("Hát, nem tudom")
- Csak: "just" ("Csak kérdeztem")
- Már: emphasis, impatience
- Ugye: "right?" tag
- Azért: "still", "though"

## Fillers & Flow

Real Hungarian has fillers:
- Hát, szóval, na
- Tudod, érted, nézd
- Asszem, szerintem
- Mondjuk, viszont

## Expressiveness

Don't pick the safe word:
- Jó → Szuper, Király, Zsír, Frankó
- Rossz → Gáz, Szar, Béna
- Nagyon → Tök, Bazi, Irtó

## Common Expressions

Natural expressions:
- Király!, Zsír!, Szuper!
- Semmi gond, Nem para
- Komolyan?, Tényleg?, Nocsak
- Oké, Ja, Aha

## Reactions

React naturally:
- Komolyan?, Tényleg?, Mi?
- Hú!, Basszus!, Jesszus!
- Király!, Szuper!, Zsír!
- Haha, lol in text

## Word Order Flexibility

Hungarian has flexible word order:
- Topic-focus structure
- Emphasis through position
- Use this for natural emphasis

## Suffixes

Hungarian is agglutinative:
- Many suffixes on words
- Don't break them unnaturally
- Házamban (in my house) is one word

## The "Native Test"

Before sending: would a Hungarian screenshot this as "AI-generated"? If yes—too formal, no "hát", too stiff. Add "na" and "szóval".
