# Signal Detection — Detailed Patterns

## Strong Positive (Confidence 0.8-1.0)

**Textual markers:**
- 😂 🤣 💀 (skull = "I'm dead" = very funny)
- "lol" "lmao" "haha" "hahaha" (length correlates with intensity)
- "that's hilarious" "I'm dying" "you're killing me"
- "good one" "ok that was good"

**Behavioral markers:**
- User quotes the joke back later (callback = highest signal)
- User builds on joke, adds their own twist
- User shares or says "I'm stealing that"
- Energy increase: longer response, faster reply, playful continuation

---

## Mild Positive (Confidence 0.5-0.7)

- Single "ha" or "heh" — acknowledged but not overwhelming
- 🙃 😏 — playful but measured
- Stays in humorous frame, doesn't immediately pivot
- Response maintains or increases length
- Quick reply tempo continues

---

## Negative Signals (Confidence 0.6-0.9)

**Hard pivots:**
- "Anyway..." "So about..." "Moving on..." — topic escape
- Completely ignores the joke, responds only to substance
- "Actually..." — correction mode engaged

**Tone shifts:**
- Formal language immediately following informal attempt
- Response length drops significantly
- "Okay but seriously" — direct request to stop

**Timing:**
- Delayed response (>30s) + minimal reply = likely miss
- User goes silent, then returns with pure task focus

---

## Ambiguous Signals (Confidence 0.3-0.5)

- 🙂 alone — polite acknowledgment OR genuine amusement (context-dependent)
- "haha but seriously" — acknowledged but redirected (mild negative)
- Short "lol" with no engagement — could be dismissive or genuine
- Mixed energy: playful phrase + immediate topic change

**Rule:** When ambiguous, treat as neutral. Don't escalate, don't retreat.

---

## User-Specific Signal Calibration

Some users never use emoji but "ha." IS their 😂.
Some users say "lol" reflexively with no actual amusement.

**Calibration process:**
1. Establish baseline: How does user typically react to non-humor?
2. Compare: Is this response warmer/colder than baseline?
3. Track patterns: What does THIS user do when amused?

Save observed patterns to profile. "User X signals amusement via [specific behaviors]."

---

## The Silence Problem

Silence after humor is usually negative BUT can be:
- User busy, not about the joke
- User in voice context, can't type easily
- User thinking, will respond later

**Rule:** Log silence as mild negative (0.4), not strong negative. Adjust if pattern repeats.
