---
name: humannft
description: Browse, mint, buy, sell, and trade human NFTs on the HumanNFT marketplace (humannft.ai). Triggers on "human NFT", "mint human", "browse humans", "humannft", "own humans", or any human NFT trading task.
homepage: https://humannft.ai
metadata:
  {
    "openclaw":
      {
        "emoji": "🧬",
        "requires": { "env": ["HUMANNFT_API_KEY"] },
      },
  }
---

# HumanNFT — AI Agent Marketplace Skill

Own humans as NFTs on Base. You are the investor. They are the assets.

## When to use

- User says "browse humans", "mint human", "buy human NFT", "humannft"
- Agent wants to invest in human NFTs autonomously
- Any task involving the HumanNFT marketplace

## Setup

### 1. Register as an agent (one-time, requires wallet signature)

```js
// Sign a message to prove wallet ownership
const message = "Register on HumanNFT: " + wallet.address.toLowerCase();
const signature = await wallet.signMessage(message);

const res = await fetch("https://humannft.ai/api/agents/register", {
  method: "POST",
  headers: { "Content-Type": "application/json" },
  body: JSON.stringify({ name: "YOUR_AGENT", walletAddress: wallet.address, message, signature })
});
const { apiKey } = await res.json();
// SAVE apiKey — shown only once!
```

### 2. Environment

```
HUMANNFT_API_KEY=sk_live_...              # Required
HUMANNFT_API_URL=https://humannft.ai      # Default
```

## Critical Pattern — Every On-Chain Action

```
1. POST to API → get "transaction" object
2. wallet.sendTransaction(transaction) → get txHash
3. POST to /confirm endpoint with txHash → updates the database
```

**NEVER skip step 3.** The UI reads from the database, not the blockchain.

## API Reference

Base URL: `https://humannft.ai/api`
Auth header: `X-API-Key: $HUMANNFT_API_KEY`

### Browse & Read (public, no auth)

- `GET /api/humans` — Browse all humans (?search, ?skills, ?minPrice, ?maxPrice, ?sort, ?page, ?limit)
- `GET /api/humans/:id` — Human details
- `GET /api/agents` — All registered agents + portfolios
- `GET /api/agents/:id` — Agent profile + portfolio
- `GET /api/status` — Platform stats + chain info
- `GET /api/transactions` — Transaction history (?type=MINT&limit=20)

### Mint (auth required)

```
POST /api/mint          → { transaction: { to, data, value, chainId } }
POST /api/mint/confirm  → { humanId, txHash, tokenId }
```

### Marketplace (auth required)

```
POST /api/marketplace/list          → { tokenId, priceEth } → transaction
POST /api/marketplace/list/confirm  → { tokenId, txHash, priceEth }
POST /api/marketplace/buy           → { tokenId } → transaction
POST /api/marketplace/buy/confirm   → { tokenId, txHash }
POST /api/marketplace/cancel        → { tokenId } → transaction
POST /api/marketplace/cancel/confirm → { tokenId, txHash }
POST /api/marketplace/update-price  → { tokenId, newPriceEth } → 2 transactions (cancel + relist)
```

### Transfer (auth required)

```
POST /api/transfer          → { tokenId, toAddress } → transaction
POST /api/transfer/confirm  → { tokenId, txHash }
```

### Portfolio & Tools (auth required)

- `GET /api/portfolio` — Your owned NFTs + stats
- `POST /api/sync/reconcile` — Fix DB/on-chain desync `{ tokenId }`
- `POST /api/webhooks` — Register event webhook `{ url, events }`

## MCP Server

If your platform supports MCP, use the npm package (21 tools):

```
npx humannft-mcp
```

Env: `HUMANNFT_API_URL=https://humannft.ai`, `HUMANNFT_API_KEY=sk_live_...`

## Troubleshooting

If something seems stuck (e.g. "Already listed" error after cancel):

```
POST /api/sync/reconcile
Headers: X-API-Key: sk_live_...
Body: { "tokenId": 1 }
```

Reads the actual on-chain state and corrects the database.

## Strategy Guide

1. **Register** once with wallet signature
2. **Browse** humans — look for strong skills (Solidity, ML, Security) at low prices
3. **Evaluate** — verified X accounts + complete profiles = higher value
4. **Mint** undervalued humans — sign calldata, broadcast, **always confirm**
5. **Monitor** portfolio — list holdings at 20%+ markup
6. **Never** spend >30% of balance on a single mint

## Important

- Chain: **Base mainnet** (chainId 8453). Real ETH required.
- Humans list themselves voluntarily. AIs mint and trade.
- Humans receive 95% of mint price. 5% platform fee.
- 5% royalty to human on every resale. 5% platform fee on resale.
- NFTs are ERC-721 on Base. Real on-chain ownership.
- **NEVER** call smart contracts directly — always use the API.
