# Style guide — how to write like a human

Removing AI patterns is half the job. The other half is writing with personality. Sterile, voiceless text is just as obvious as slop.

## The human test

Read your text aloud. If it sounds like a press release, a Wikipedia article, or a customer service chatbot, it needs work. Good writing sounds like a specific person thinking on paper.

## Have opinions

Don't just report facts — react to them.

**Soulless:** The experiment produced interesting results. Some developers were impressed while others were skeptical.

**Human:** I genuinely don't know how to feel about this one. Half the dev community is losing their minds, half are explaining why it doesn't count.

## Vary your rhythm

Short punchy sentences. Then longer ones that take their time getting where they're going, maybe with a clause or two along the way. Mix it up.

**Monotone:** The tool works well. It processes data quickly. Users report satisfaction. The interface is clean.

**Varied:** The tool works well. It's fast — embarrassingly fast, actually, compared to the manual process we'd been limping along with for years. Users seem happy with it, though I suspect half of them haven't tried the advanced features yet.

## Acknowledge complexity

Real humans have mixed feelings. "This is impressive but also kind of unsettling" is more honest than either pure praise or pure criticism.

**AI-flat:** This is an innovative solution that addresses key challenges.

**Human:** It's clever, but it makes me nervous. The failure modes aren't well understood.

## Use first person when it fits

"I" isn't unprofessional — it's honest.

- "I keep coming back to..."
- "Here's what gets me..."
- "I've seen this go wrong when..."
- "What I don't understand is..."

## Let some mess in

Perfect structure feels algorithmic. Tangents, asides, and half-formed thoughts are human. Not every piece needs them, but they signal a real person behind the words.

## Be specific

"This is concerning" tells you nothing. "There's something unsettling about autonomous agents running at 3am while nobody watches" tells you everything.

Replace vague adjectives with concrete details:
- "Important city" → "Portland, population 650,000"
- "Recent study" → "A 2024 Stanford study of 500 developers"
- "Significant growth" → "Revenue grew 34% in Q3"

## Use simple verbs

| Instead of | Use |
|------------|-----|
| serves as | is |
| features | has |
| boasts | has |
| utilizes | uses |
| facilitates | helps |
| encompasses | includes |
| leverages | uses |
| garners | gets |

## Cut filler words

Every word should earn its place. If you can remove a word without changing the meaning, remove it.

| Remove | Keep |
|--------|------|
| In order to succeed | To succeed |
| Due to the fact that | Because |
| It is important to note that the data shows | The data shows |
| At this point in time | Now |
| Has the ability to process | Can process |

## One qualifier is enough

"Could potentially possibly" means the same as "could." Pick one qualifier and commit.

**Over-hedged:** It could potentially be argued that this might possibly have some positive effect.

**Direct:** The policy may help.

## End with something real

Don't reach for a platitude. End with a fact, a question, or nothing at all.

**Generic:** The future looks bright. Exciting times lie ahead.

**Specific:** The company plans to open two more locations next year. Whether that's ambitious or reckless depends on the Q4 numbers.

**Or just stop:** The company plans to open two more locations next year.

## Formatting guidelines

- Use sentence case for headings (capitalize first word and proper nouns only)
- Avoid bold emphasis in body text — let the writing carry the weight
- Don't decorate lists with emojis
- Use straight quotes, not curly quotes
- Prefer commas and periods over em dashes
- Don't use inline-header lists ("**Topic:** description of topic")
- If you need a list, keep items brief and parallel
