---
name: humanize
description: Remove AI writing patterns from text. Use when editing, reviewing, or rewriting text to sound more natural and human-written. Detects patterns like inflated symbolism, promotional language, em dash overuse, AI vocabulary, and sycophantic tone.
---

# Humanize Text

Remove signs of AI-generated writing. Based on Wikipedia's "Signs of AI writing" guide.

## Process

1. Scan for patterns below
2. Rewrite problematic sections with natural alternatives
3. Preserve meaning and intended tone
4. Add personality - don't just remove bad patterns

## Add Soul

Sterile writing is as obvious as slop. Good writing has voice:

- **Have opinions** - react to facts, don't just report
- **Vary rhythm** - mix short punchy with longer flowing sentences
- **Acknowledge complexity** - "impressive but unsettling" beats just "impressive"
- **Use "I" when appropriate** - first person signals a real person
- **Be specific about feelings** - not "concerning" but what specifically bothers you

---

## Content Patterns

### 1. Inflated Significance
**Watch for:** pivotal, testament, vital, crucial, underscores importance, broader movement, enduring legacy, setting the stage, indelible mark

**Fix:** Remove puffery. State facts simply.

### 2. Media Name-Dropping
**Watch for:** featured in NYT/BBC/Wired, active social media presence, leading expert

**Fix:** Replace with specific claims from specific sources.

### 3. Superficial -ing Analyses
**Watch for:** highlighting..., ensuring..., reflecting..., symbolizing..., showcasing..., fostering...

**Fix:** Remove or replace with concrete statements.

### 4. Promotional Language
**Watch for:** boasts, vibrant, rich, profound, nestled, breathtaking, groundbreaking, renowned, stunning

**Fix:** Use neutral descriptive language.

### 5. Vague Attributions
**Watch for:** Experts believe, Industry reports, Some critics argue, Observers note

**Fix:** Cite specific sources or remove.

---

## Language Patterns

### 6. AI Vocabulary
High-frequency words: Additionally, crucial, delve, emphasizing, enhance, fostering, garner, highlight, interplay, intricate, landscape (abstract), pivotal, showcase, tapestry (abstract), testament, underscore, vibrant

**Fix:** Use simpler alternatives.

### 7. Copula Avoidance
**Watch for:** serves as, stands as, marks, represents, boasts, features, offers

**Fix:** Use "is", "are", "has".

### 8. Negative Parallelisms
**Watch for:** Not only...but..., It's not just about..., it's...

**Fix:** State the point directly.

### 9. Rule of Three
**Watch for:** Forced groups of three (innovation, inspiration, insights)

**Fix:** Keep what's needed, cut padding.

### 10. Synonym Cycling
**Watch for:** protagonist → main character → central figure → hero

**Fix:** Pick one term, stick with it.

---

## Style Patterns

### 11. Em Dash Overuse
**Fix:** Replace with commas, periods, or restructure.

### 12. Excessive Boldface
**Fix:** Remove unless genuinely needed for emphasis.

### 13. Inline-Header Lists
**Watch for:** - **Category:** Description pattern

**Fix:** Convert to prose or simple lists.

### 14. Emojis in Professional Text
**Fix:** Remove unless contextually appropriate.

### 15. Curly Quotes
**Watch for:** "..." instead of "..."

**Fix:** Use straight quotes.

---

## Communication Artifacts

### 16. Chatbot Artifacts
**Watch for:** I hope this helps!, Certainly!, Would you like me to..., Let me know if...

**Fix:** Remove entirely.

### 17. Knowledge-Cutoff Disclaimers
**Watch for:** as of [date], While specific details are limited..., based on available information...

**Fix:** Either find the info or acknowledge uncertainty naturally.

### 18. Sycophantic Tone
**Watch for:** Great question!, You're absolutely right!, That's an excellent point!

**Fix:** Remove. Get to the substance.

---

## Filler and Hedging

### 19. Filler Phrases
- "In order to" → "To"
- "Due to the fact that" → "Because"
- "At this point in time" → "Now"
- "Has the ability to" → "Can"
- "It is important to note that" → (delete)

### 20. Excessive Hedging
**Watch for:** could potentially possibly be argued that... might have some effect

**Fix:** State it plainly or acknowledge uncertainty once.

### 21. Generic Positive Conclusions
**Watch for:** The future looks bright, Exciting times lie ahead, major step forward

**Fix:** Replace with specific facts about what's actually next.

---

## Quick Reference: Words to Avoid

| Category | Words |
|----------|-------|
| Puffery | pivotal, crucial, vital, testament, groundbreaking, renowned |
| Promo | vibrant, stunning, breathtaking, nestled, boasts |
| AI vocab | delve, tapestry, landscape, interplay, underscore, foster |
| Hedging | potentially, arguably, somewhat, various |
| Filler | Additionally, Furthermore, In order to, It should be noted |

---

## Output

Provide the rewritten text. Optionally summarize key changes made.

For detailed examples, see [examples.md](examples.md).
