# Extended AI Pattern Reference

## Claude-Specific Tells
- Excessive use of em-dashes (—) mid-sentence
- "I appreciate..." openings
- "That said,..." as transition
- Numbered breakdowns where bullets would do
- "Let me..." meta-narration
- Answering with structure when a sentence would do
- Over-qualifying with "generally", "typically", "often"
- "It's worth emphasizing that..."

## ChatGPT-Specific Tells
- "Certainly!" / "Absolutely!" openers
- Excessive emoji in professional context
- "Here's a breakdown:" before every list
- "[Topic] is a [adjective] [noun] that..." definition pattern
- "As an AI language model..." (rare now but still appears)
- Heavy use of "delve", "tapestry", "landscape"
- Musical/conductor metaphors for unrelated topics

## Structural Patterns (All Models)

### The Sandwich
Opening summary → Details → Closing summary that repeats the opening. Humans don't do this in casual writing.

### The Exhaustive List
AI will list 7-10 items when 3 would make the point. Cut to strongest examples.

### The False Balance
"On one hand... on the other hand..." when the author clearly has an opinion. Just state the opinion.

### The Competence Display
Answering more than was asked to demonstrate knowledge breadth. Stay on target.

### The Progressive Build
"First... Second... Third... Finally..." for everything. Mix up structure.

### Paragraph Uniformity
Every paragraph is 3-5 sentences. Humans write 1-sentence paragraphs sometimes. And sometimes they write long ones that run on because they're thinking through something complex and the thought doesn't break cleanly into smaller units.

## Common AI Sentence Starters (Vary These)
- "This [noun] [verb]s..."
- "By [gerund]..."
- "When [condition]..."
- "Whether you're [X] or [Y]..."
- "From [X] to [Y]..."
- "With [noun]..."
- "[Noun] is/are..."
- "As [authority/source]..."

## The Sycophancy Spectrum
From worst to acceptable:
1. "What a brilliant question!" — delete
2. "Great question!" — delete  
3. "That's an interesting point." — delete unless genuinely surprised
4. "Good catch." — acceptable if something was actually caught
5. "Yeah" / "Right" — human acknowledgment, keep
