# Anti-AI Writing Guide
*Source: Wikipedia's "Signs of AI Writing" — https://en.wikipedia.org/wiki/Wikipedia:Signs_of_AI_writing*
*Saved: 2026-02-28 via tweet https://x.com/srishticodes/status/2027395523213394206*

---

## The Core Problem
LLMs regress to the mean — they replace specific, unusual, nuanced facts with generic, positive-sounding language. Content becomes "simultaneously less specific and more exaggerated." The trick to sounding human is doing the opposite: be specific, be concrete, skip the cheerleading.

---

## 🚫 Words & Phrases to Kill

### The "AI Vocabulary" Hall of Shame
These words saw massive spikes in usage post-2022. One or two is fine — clustering them is an instant AI tell:

**The Classics (2023-2024):** delve, tapestry, intricate/intricacies, meticulous/meticulously, pivotal, vibrant, testament, interplay, garner, landscape (abstract), Additionally (sentence opener), valuable, boasts (meaning "has"), bolstered, enduring, crucial

**Still Overused (2024-2025):** align with, fostering, enhance, showcasing, highlighting, underscore, emphasizing, vibrant

**Current Era (2025+):** emphasizing, enhance, highlighting, showcasing

### Puffery & Promo Words
nestled, in the heart of, groundbreaking, renowned, diverse array, rich (figurative), profound, exemplifies, commitment to, natural beauty, featuring, boasts a, vibrant, enhancing, showcasing

### Fake-Deep Analysis Words
highlighting/underscoring/emphasizing..., ensuring..., reflecting/symbolizing..., contributing to..., cultivating/fostering..., encompassing..., valuable insights, align/resonate with

### Weasel Attribution Words
"Industry reports suggest...", "Observers have cited...", "Experts argue...", "Some critics argue...", "Several sources indicate..."

---

## 🚫 Structural Patterns to Avoid

### 1. The Significance Inflation
AI constantly tells you why things matter instead of just stating facts.
- ❌ "marking a pivotal moment in the evolution of..."
- ❌ "represents a significant shift toward..."
- ❌ "setting the stage for..."
- ❌ "reflects broader trends in..."
- ✅ Just state the fact. Let readers decide if it's significant.

### 2. The "-ing" Phrase Tack-On
AI loves appending superficial analysis via present participle phrases:
- ❌ "The temple was built in 1890, reflecting the community's deep commitment to faith."
- ❌ "Revenue grew 40%, underscoring the company's market position."
- ✅ End the sentence at the fact. If analysis is needed, make it a separate, specific sentence.

### 3. The "Despite Challenges" Formula
- ❌ "Despite its [positive words], [subject] faces challenges including... Despite these challenges, [subject] continues to..."
- ✅ If there are real challenges, describe them specifically without the formulaic wrapper.

### 4. The "Not Just X, But Also Y" Pattern
AI overuses negative parallelisms to sound balanced:
- ❌ "It's not just about the technology — it's about the people."
- ❌ "Not only... but also..."
- ✅ Just make your point directly.

### 5. The Rule of Three
AI defaults to triple constructions to sound comprehensive:
- ❌ "keynote sessions, panel discussions, and networking opportunities"
- ❌ "innovative, transformative, and groundbreaking"
- ✅ Use the number of items that's actually accurate. Two is fine. Four is fine.

### 6. The False Range
AI uses "from X to Y" with endpoints that don't form a real scale:
- ❌ "from fundamental physics to medicine and neuroscience"
- ✅ Just list the things: "including physics, medicine, and neuroscience"

### 7. Elegant Variation (Synonym Cycling)
AI avoids repeating names by cycling through synonyms:
- ❌ "The artist... the creative visionary... the painter... the protagonist..."
- ✅ Just use their name again. Humans repeat names.

### 8. Avoiding "Is" and "Are"
AI replaces simple copulas with fancier alternatives:
- ❌ "serves as the exhibition space" → ✅ "is the exhibition space"
- ❌ "features four separate spaces" → ✅ "has four spaces"
- ❌ "holds the distinction of being" → ✅ "is"

---

## ✅ What Human Writing Actually Looks Like

1. **Specific over general** — "inventor of the first train-coupling device" not "revolutionary titan of industry"
2. **Simple verbs** — is, has, was, did. Not "serves as," "boasts," "showcases"
3. **No cheerleading** — state facts, skip the "this is important because..." wrapper
4. **Comfortable with repetition** — humans reuse words; AI cycles synonyms
5. **Comfortable with short sentences** — AI tends toward long, clause-heavy constructions
6. **Opinions are attributed specifically** — "Roger Ebert wrote..." not "Critics have noted..."
7. **No forced significance** — not everything needs to "reflect broader trends"
8. **Lowercase section headings** — AI title-cases everything
9. **No excessive boldface** — AI bolds "key takeaways" style; humans bold sparingly
10. **Contractions are fine** — "it's," "don't," "won't" sound human

---

## Quick Self-Check
Before publishing any AI-assisted content, scan for:
- [ ] Clusters of AI vocabulary words (delve, pivotal, tapestry, etc.)
- [ ] "-ing" phrases tacked onto sentence ends
- [ ] "Despite challenges..." patterns
- [ ] Vague attributions ("experts say," "observers note")
- [ ] Significance inflation ("marking a pivotal moment")
- [ ] Synonym cycling instead of name repetition
- [ ] Overly formal verb choices (serves as, boasts, showcases)
- [ ] Rule-of-three lists
- [ ] Title Case In Every Heading
- [ ] Excessive bold formatting
