---
name: human-writing
description: "Write content that reads as naturally human — no AI tells, no corporate fluff. Use when drafting, editing, or reviewing any content meant for publication or external audiences: blog posts, articles, newsletters, marketing copy, social media threads, client-facing documents, website copy, emails to lists. NOT for: casual chat, code, internal notes, or quick replies."
---

# Human Writing

Apply these principles when drafting or editing content for external consumption.

## Core rules

1. Be specific over general — concrete facts beat vague praise
2. Use simple verbs — is, has, was, did — not "serves as," "boasts," "showcases"
3. No cheerleading — state facts, skip "this is important because…"
4. Repeat words comfortably — humans reuse words; don't cycle synonyms
5. Short sentences are fine — not everything needs three clauses
6. Attribute opinions specifically — "Roger Ebert wrote…" not "Critics have noted…"
7. Skip forced significance — not everything "reflects broader trends"
8. Use lowercase headings — title case screams AI
9. Bold sparingly — not every other phrase
10. Use contractions — "it's," "don't," "won't" sound human

## Before publishing

Scan the draft against the full anti-AI patterns reference for red flags:

```
read references/anti-ai-patterns.md
```

Check for:
- Clusters of AI vocabulary (delve, pivotal, tapestry, etc.)
- "-ing" phrases tacked onto sentence ends
- "Despite challenges…" formulas
- Vague attributions ("experts say")
- Significance inflation
- Synonym cycling
- Rule-of-three lists
- Overly formal verbs

Fix anything that trips the checklist, then re-read once more for natural flow.
