# AI Writing Signs (Comprehensive Field Guide)

This guide catalogs the specific linguistic and structural "tells" identified by the Wikipedia community (WP:SIGNS) to help detect and avoid AI-generated content in professional documentation.

## 1. High-Density "AI Vocabulary"
These words are statistically overrepresented in LLM outputs. One or two might be a coincidence; a high density is a certain "tell."

### The "Era" Specific Tells:
- **Pre-2024 (GPT-4 legacy):** Additionally (especially at sentence start), boasts, bolstered, crucial, delve, emphasizing, enduring, garner, intricate, interplay, key, landscape, meticulous, pivotal, underscore, tapestry, testament, valuable, vibrant.
- **Mid-2024 to 2025 (GPT-4o/5):** Align with, enhance, fostering, highlighting, showcasing, multifaceted, evolving, underscores.

### Prohibited Verbs/Phrases:
- **Avoid:** "serves as/stands as" instead of simple "is/are."
- **Avoid:** "features/offers" instead of simple "has."
- **Avoid:** "embodies," "captivates," "navigates," "masterfully," "seamlessly."

## 2. Puffy & Promotional Tone (Puffery)
LLMs tend to "puff up" subjects, adding generic importance to mundane data.

- **The "Significance" Tell:** Phrases like "marking a pivotal moment," "is a testament to," "highlights the importance of," "reflects broader trends."
- **The "Peacock" Tell:** Phrases like "nestled in the heart of," "boasts a rich history," "renowned for," "vibrant community."
- **The "Legacy" Tell:** Forcing a section on "Legacy and Influence" for every subject.

## 3. Structural Formulae (The "Crutches")
- **The Rule of Three:** Adjective/phrase triplets like "fast, secure, and reliable" or "keynote sessions, panel discussions, and networking opportunities."
- **Negative Parallelisms:** 
  - "Not just X, but also Y."
  - "It's not about A, it's about B."
- **Vague Outlines:** Always ending with "Challenges and Future Outlook" or "Conclusion."
- **The "AI Sandwich":** A rigid [Intro -> 3 Paragraphs -> Summary] structure.

## 4. Superficial Analysis
AI often attaches "meaningless" depth to facts using present participle phrases.
- **Example:** "The population stands at 50k, *creating a lively community within its borders.*" (The italicized part is a common AI fabrication/filler).
- **Vague Attributions:** "Industry reports suggest," "experts argue," "some critics say" (weasel words without specific citations).

## 5. Stylistic & Formatting Tells
- **Elegant Variation:** Using forced synonyms (e.g., "the protagonist," "the key player," "the eponymous character") to avoid repeating a person's name too often.
- **False Ranges:** "From X to Y" where X and Y don't actually form a logical scale (e.g., "from fundamental physics to medicine").
- **Leads as Proper Nouns:** Starting a list article with "The 'List of Songs' is a curated compilation..." as if the list itself is a standalone entity.
- **Mechanical Boldface:** Boldfacing every instance of a key term or using bold lists for every minor source.
- **Title Case Headings:** Capitalizing Every Word in a Heading regardless of standard sentence case style.

## 6. Logical Flaws
- **Superficial Links:** Filling "See Also" sections with extremely broad terms like "Financial Technology" for a specific small startup.
- **Over-attribution:** Listing news outlets (Wired, Vogue, CNN) to prove notability instead of summarizing the actual content they published.
- **Social Media Clichés:** Overusing "maintains an active social media presence" or "strong digital footprint."
