# 华为云产品目录

本文档整理华为云主要产品的规格、适用场景和选型建议。

## 目录

1. [计算资源](#计算资源)
2. [存储资源](#存储资源)
3. [网络资源](#网络资源)
4. [数据库服务](#数据库服务)
5. [中间件服务](#中间件服务)
6. [安全服务](#安全服务)
7. [管理与监控](#管理与监控)

---

## 计算资源

### 弹性云服务器 (ECS)

**用途：** 通用计算、Web服务器、应用服务器

**规格族：**

| 规格族 | 类型 | 适用场景 | 特点 |
|--------|------|----------|------|
| 通用型 (s系列) | s6, s7 | 中小型应用、企业办公 | 均衡性能 |
| 计算型 (c系列) | c6, c7 | 高性能计算、科学计算 | 高CPU配比 |
| 内存型 (m系列) | m6, m7 | 大数据分析、数据库 | 高内存配比 |
| GPU加速型 (g系列) | g6, pi2 | AI训练、图形渲染 | GPU加速能力 |

**常用规格：**

| 规格代码 | vCPU | 内存(GiB) | 典型用途 |
|----------|------|-----------|----------|
| s6.small.1 | 1 | 1 | 测试/开发 |
| s6.medium.2 | 1 | 2 | 轻量应用 |
| s6.large.2 | 2 | 4 | Web服务器 |
| s6.xlarge.2 | 4 | 8 | 应用服务器 |
| s6.2xlarge.2 | 8 | 16 | 中型应用 |
| c6.xlarge.4 | 4 | 16 | 计算密集型 |
| m6.xlarge.8 | 4 | 32 | 内存密集型 |

**选型建议：**
- 开发测试：s6.medium.2 ~ s6.large.2
- Web应用：s6.large.2 ~ s6.xlarge.2
- 数据库服务器：m6.large.4 ~ m6.xlarge.8

---

### 云容器引擎 (CCE)

**用途：** 容器化应用、微服务架构

**节点规格：**

| 类型 | 说明 |
|------|------|
| 虚拟机节点 | 基于 ECS，灵活配置 |
| 物理机节点 | 裸金属服务器，高性能 |

**关键配置：**
- 节点数量：建议至少3个（高可用）
- 节点规格：根据容器密度选择
- 网络模式：VPC网络 / 容器隧道网络

---

### 函数计算 (FunctionGraph)

**用途：** 事件驱动、无服务器架构

**计费方式：** 按调用次数和执行时长

**适用场景：**
- API后端
- 数据处理
- 定时任务
- 事件响应

---

## 存储资源

### 对象存储服务 (OBS)

**用途：** 静态资源、备份归档、大数据存储

**存储类别：**

| 类别 | 访问频率 | 存储成本 | 适用场景 |
|------|----------|----------|----------|
| 标准存储 | 高 | 高 | 热点图片、视频 |
| 低频存储 | 低 | 中 | 备份数据 |
| 归档存储 | 极低 | 低 | 长期归档 |

**定价参考：**
- 标准存储：~¥0.12/GB/月
- 低频存储：~¥0.08/GB/月
- 归档存储：~¥0.033/GB/月

---

### 云硬盘 (EVS)

**用途：** ECS系统盘、数据盘

**磁盘类型：**

| 类型 | IOPS | 吞吐量 | 适用场景 |
|------|------|--------|----------|
| 普通IO (SATA) | 500-1500 | 低 | 开发测试 |
| 高IO (SAS) | 1500-5000 | 中 | 一般应用 |
| 通用型SSD | 5000-20000 | 高 | 数据库 |
| 极速型SSD | 最高128000 | 极高 | 高性能数据库 |

**容量范围：** 10GB ~ 32TB

---

### 弹性文件服务 (SFS)

**用途：** 共享文件存储、高性能计算

**类型：**
- SFS Capacity-Oriented：容量型，大容量低成本
- SFS Performance-Oriented：性能型，高吞吐

---

## 网络资源

### 虚拟私有云 (VPC)

**用途：** 隔离的网络环境

**关键配置：**

| 配置项 | 建议值 | 说明 |
|--------|--------|------|
| 网段 | 10.0.0.0/16 ~ /24 | 足够地址空间 |
| 子网 | 按可用区划分 | 高可用部署 |
| 安全组 | 最小权限原则 | 限制入站/出站 |

**常见网段规划：**

```
VPC: 10.0.0.0/16
├── 公有子网-AZ1: 10.0.1.0/24  (ELB、NAT网关)
├── 公有子网-AZ2: 10.0.2.0/24
├── 私有子网-AZ1: 10.0.10.0/24 (ECS、RDS)
└── 私有子网-AZ2: 10.0.20.0/24
```

---

### 弹性负载均衡 (ELB)

**用途：** 流量分发、高可用

**类型：**

| 类型 | 特点 | 适用场景 |
|------|------|----------|
| 共享型 | 共享带宽 | 小型应用 |
| 独享型 | 独享带宽 | 大型应用 |

**协议支持：** HTTP/HTTPS/TCP/UDP

---

### 弹性公网IP (EIP)

**用途：** 公网访问

**带宽类型：**
- 按带宽计费：固定带宽
- 按流量计费：按实际流量

**建议：**
- Web服务：按带宽计费
- 临时访问：按流量计费

---

### NAT网关

**用途：** 私有子网访问公网

**类型：**
- 公网NAT网关：SNAT/DNAT
- 私网NAT网关：跨VPC通信

---

## 数据库服务

### 关系型数据库 (RDS)

**用途：** 关系型数据存储

**引擎支持：**

| 引擎 | 版本 | 适用场景 |
|------|------|----------|
| MySQL | 5.6, 5.7, 8.0 | Web应用、电商 |
| PostgreSQL | 10, 11, 12, 13 | 复杂查询、GIS |
| SQL Server | 2016, 2017, 2019 | 企业应用 |
| MariaDB | 10.5 | 兼容MySQL |

**规格示例：**

| 规格代码 | vCPU | 内存(GiB) | 适用场景 |
|----------|------|-----------|----------|
| rds.mysql.c6.large.2 | 2 | 4 | 小型应用 |
| rds.mysql.c6.xlarge.2 | 4 | 8 | 中型应用 |
| rds.mysql.c6.2xlarge.2 | 8 | 16 | 大型应用 |

**高可用配置：**
- 主备实例：自动故障切换
- 只读实例：读写分离

---

### 分布式数据库 (GaussDB)

**用途：** 大规模分布式事务

**特点：**
- 水平扩展
- 高可用
- 分布式事务

---

### 文档数据库 (DDS)

**用途：** NoSQL存储，文档型数据

**引擎：** MongoDB 兼容

**架构：**
- 副本集：高可用
- 集群：大规模数据

---

### 分布式缓存 (DCS)

**用途：** 缓存、会话管理

**引擎：**
- Redis：高性能缓存
- Memcached：简单缓存

**规格：**
- 单机：开发测试
- 主备：生产环境
- 集群：大容量高并发

---

## 中间件服务

### 分布式消息服务 (DMS)

**用途：** 异步通信、解耦

**类型：**
- Kafka：高吞吐
- RabbitMQ：可靠消息
- RocketMQ：事务消息

---

### API网关 (APIG)

**用途：** API管理、流量控制

**功能：**
- API发布
- 流量控制
- 认证鉴权
- 监控统计

---

## 安全服务

### Web应用防火墙 (WAF)

**用途：** Web安全防护

**防护能力：**
- SQL注入防护
- XSS防护
- CC攻击防护
- 精准访问控制

---

### DDoS防护

**类型：**
- Anti-DDoS Basic：免费基础防护
- Anti-DDoS Pro：高防IP

---

### 数据加密服务 (KMS)

**用途：** 密钥管理、数据加密

**功能：**
- 密钥生命周期管理
- 数据加密/解密
- 密钥审计

---

## 管理与监控

### 云监控服务 (CES)

**用途：** 资源监控、告警

**监控指标：**
- CPU使用率
- 内存使用率
- 网络流量
- 磁盘使用率

---

### 云审计服务 (CTS)

**用途：** 操作审计、合规

**记录内容：**
- API调用记录
- 资源变更记录
- 操作时间、操作者

---

### 统一身份认证 (IAM)

**用途：** 权限管理

**功能：**
- 用户/用户组管理
- 角色授权
- 细粒度权限控制

---

## 选型速查表

| 业务场景 | 计算资源 | 数据库 | 缓存 | 存储 |
|----------|----------|--------|------|------|
| 小型Web应用 | ECS s6.large.2 | RDS MySQL | DCS Redis | OBS + EVS |
| 中型Web应用 | ECS s6.xlarge.2 × 2 | RDS 主备 | DCS 主备 | OBS + EVS |
| 大型Web应用 | ECS 集群 + ELB | RDS 集群 | DCS 集群 | OBS + EVS + SFS |
| 微服务架构 | CCE 集群 | RDS/GaussDB | DCS Redis | OBS |
| 大数据平台 | MRS 集群 | DWS | - | OBS |
| AI训练平台 | GPU ECS + ModelArts | RDS | - | OBS |

---

*注：本文档为基础参考，实际规格和价格请以华为云官网为准。*
