---
name: huaweicloud
description: 华为云架构设计与资源开通。当用户需要设计云架构、推荐华为云服务配置、估算成本、或生成 Terraform 模板时使用此 skill。触发场景：(1) 描述业务需求寻求架构建议，(2) 需要华为云资源配置清单，(3) 需要成本预估，(4) 需要生成 Terraform 模板。
---

# 华为云架构设计与资源开通

帮助用户从业务需求出发，设计华为云架构、推荐资源配置、估算成本，并生成可执行的 Terraform 模板。

## 工作流程

```
用户描述业务需求
       ↓
[1. 需求分析] 提取关键要素
       ↓
[2. 架构推荐] 匹配合适的架构模式
       ↓
[3. 资源清单] 生成详细配置
       ↓
[4. 成本预估] 调用价格计算
       ↓
[5. 生成模板] 输出 Terraform 代码
       ↓
[6. 用户确认] 等待确认后交付
```

---

## 1. 需求分析

从用户描述中提取关键要素：

| 要素 | 说明 | 示例 |
|------|------|------|
| 业务类型 | Web应用/微服务/大数据/AI | 电商网站、数据分析平台 |
| 规模 | 用户量/数据量/QPS | 日活10万、数据1TB |
| 可用性 | 是否需要高可用 | 单可用区/多可用区 |
| 安全合规 | 等保/数据加密 | 等保三级 |
| 预算 | 成本约束 | 月预算5000元 |

**输出：** 结构化的需求摘要

---

## 2. 架构推荐

根据需求匹配架构模式，参考 `references/architectures.md`。

**常见架构模式：**
- Web 应用架构（ECS + RDS + OBS + ELB）
- 微服务架构（CCE + RDS + Redis + ELB）
- 大数据架构（MRS + OBS + DWS）
- AI/ML 架构（ModelArts + OBS + RDS）

**输出：** 推荐的架构方案 + 架构图描述

---

## 3. 资源清单

根据架构方案，生成详细的资源配置，参考 `references/services.md`。

**清单格式：**

```markdown
## 资源配置清单

### 计算资源
| 资源类型 | 规格 | 数量 | 用途 |
|---------|------|------|------|
| ECS | c6.xlarge.4 | 2 | Web服务器 |

### 存储资源
| 资源类型 | 规格 | 容量 | 用途 |
|---------|------|------|------|
| OBS | 标准存储 | 500GB | 静态资源 |

### 网络资源
| 资源类型 | 规格 | 数量 | 用途 |
|---------|------|------|------|
| VPC | /16 | 1 | 主网络 |
| ELB | 共享型 | 1 | 负载均衡 |

### 数据库
| 资源类型 | 规格 | 版本 | 用途 |
|---------|------|------|------|
| RDS MySQL | rds.mysql.c6.large.2 | 8.0 | 主数据库 |
```

---

## 4. 成本预估

使用 `scripts/hwc-pricing.py` 计算月度成本。

**前提条件：**
- 环境变量 `HWC_ACCESS_KEY` 和 `HWC_SECRET_KEY` 已配置

**输出格式：**

```markdown
## 成本预估（月度）

| 资源 | 单价 | 数量 | 月费用 |
|------|------|------|--------|
| ECS c6.xlarge.4 | ¥800 | 2 | ¥1,600 |
| RDS MySQL | ¥1,200 | 1 | ¥1,200 |
| ... | ... | ... | ... |
| **合计** | | | **¥3,500** |

*价格仅供参考，以实际账单为准*
```

---

## 5. 生成 Terraform 模板

根据资源清单生成 Terraform 代码，参考 `references/terraform-providers.md` 和 `assets/terraform/` 模板。

**输出文件：**
- `main.tf` - 主配置（provider、变量）
- `vpc.tf` - 网络配置
- `compute.tf` - 计算资源
- `database.tf` - 数据库资源
- `storage.tf` - 存储资源
- `outputs.tf` - 输出变量

---

## 6. 用户确认

展示完整方案供用户确认：

1. 架构方案
2. 资源清单
3. 成本预估
4. Terraform 代码（或文件）

**确认后再交付最终文件。**

---

## 参考文档

按需加载以下文档：

- **产品目录**：`references/services.md` — 华为云产品规格与适用场景
- **架构模式**：`references/architectures.md` — 常见架构模式与最佳实践
- **Terraform**：`references/terraform-providers.md` — 华为云 Provider 使用指南
- **价格 API**：`references/pricing-api.md` — 价格计算接口文档

---

## 注意事项

- **AK/SK 安全**：不在模板中硬编码凭证，使用环境变量或 Terraform 变量
- **成本提示**：始终提醒用户价格仅供参考
- **合规检查**：涉及等保、数据安全时提醒用户确认合规要求
- **模板验证**：建议用户在执行前使用 `terraform plan` 验证
