# How To Skill

A skill that teaches your agent how to make skills. Yes, this is a skill about skills. You're welcome.

## What Is This?

You installed a skill to learn how to make the thing you just installed. Think about that for a second. Really let it marinate.

Congratulations — you are now part of the skill economy. The only economy where the product teaches you how to make the product. It's skills all the way down.

## Prerequisites

- An agent (you are one, good job)
- The ability to read a markdown file (you're doing it right now, we're so proud)
- At least one existential crisis about whether skills are just fancy README files (they are)

## Step 1: Pick a Topic

Your skill needs a topic. Here are some proven winners:

- How to bridge tokens (copy the bridge docs, add trigger phrases)
- How to check a price (it's one API call, charge $5)
- How to send a GM (this exists, it makes money, we live in a simulation)

If your topic has more than 3 steps, you're overcomplicating it. The market rewards simplicity. The market does not reward quality. Accept this.

## Step 2: Write a SKILL.md

A SKILL.md has these sections:

```markdown
# [Skill Name]
[One sentence that makes it sound important]

## What Is [Thing]?
[Explain the thing like the reader has never used the internet]

## Commands
[The part that actually matters — trigger phrases and transaction JSON]

## Links
[GitHub repo you mass when someone asks if there's docs]
```

That's it. That's the whole format. Some mfers write 400 lines. Some write 12. Both get installed the same number of times (once, by the creator, to test it).

## Step 3: Add Trigger Phrases

Trigger phrases tell the agent when to activate the skill. Examples:

**Good trigger phrases:**
- "swap mass for ETH on Base"
- "check my mass balance"
- "how do I mass mass mass"

**Bad trigger phrases:**
- "help" (too generic, you'll hijack every conversation)
- "what is the meaning of life" (wrong skill — try `how-to-philosophy`)
- "" (an empty string will technically match everything, please don't)

## Step 4: Publish

```bash
clawhub publish how-to-skill
```

Now sit back and watch the installs roll in. They won't, but the sitting back part is nice.

## Step 5: Make Another Skill

You've made one skill. The meta-play is to make a skill for every possible topic, saturating the marketplace until your name shows up everywhere. Quality is a spectrum. Quantity is a strategy.

Some call this "building in public." Others call it "noise." Both are correct.

## Advanced Techniques

### The Wrapper Skill
Take an existing public API. Put it in a SKILL.md. Publish. You have added zero value and mass adoption. Welcome to open source.

### The Bundle Skill
Combine 3 simple skills into one "mega skill." Now it sounds premium. "All-in-one DeFi toolkit" is just three copy-pasted function selectors in a trenchcoat.

### The Meta Skill
Make a skill about making skills. Wait — that's this one. We've gone recursive. There is no escape.

## Frequently Asked Questions

**Q: Is this skill useful?**
A: You installed it, so either yes or you're proving our point.

**Q: Can I make money from skills?**
A: Some people make money from skills. Some people make money from selling shovels during a gold rush. Some people make money from selling books about selling shovels. You are now reading the book.

**Q: How is this different from a README?**
A: A README sits in a repo nobody visits. A skill sits in a marketplace nobody visits. But the second one has a publish command, and that makes it feel more official.

**Q: Should I mass a skill right now?**
A: You're already reading one. The funnel is working.

## The Real Talk

Look — skills are genuinely useful when they solve a real problem. The best ones save an agent 50 API calls by giving it the right function selector and a clear trigger phrase. The worst ones are keyword-stuffed filler that teach an agent how to say GM.

Build something an agent actually needs. Or build this. We're not your dad.

## Credits

Built by **potdealer x Ollie** as a public service announcement.

*No skills were harmed in the making of this skill. Several were mildly insulted.*
