# hoverbot-chatbot

A ClawHub skill that lets any AI agent create, customize, and embed AI chatbots on websites using [HoverBot](https://hoverbot.ai).

## What it does

This skill teaches your agent how to:

- Set up a chatbot in under 2 minutes (no credit card needed)
- Choose from pre-built templates (Customer Support, FAQ, Sales Assistant, Product Guide)
- Customize branding (name, color, greeting message)
- Generate and embed the widget code on any website
- Train the bot with custom knowledge (PDFs, URLs)
- Control the widget programmatically via JavaScript API

## Install

```bash
clawhub install hoverbot-chatbot
```

## Quick Example

Ask your agent:

> "Help me add a customer support chatbot to my website"

The agent will walk you through the 3-step setup at `sandbox.hoverbot.ai/get-started` and provide the embed code.

## Templates

| Template | Best For |
|----------|----------|
| Customer Support | Answering questions, resolving issues |
| FAQ Bot | Knowledge-base Q&A |
| Sales Assistant | Product discovery, comparisons, purchasing |
| Product Guide | Feature walkthroughs, documentation |

## Requirements

- A website where you can edit HTML (to paste the embed code)
- An email address (to create a HoverBot account)

## Links

- [HoverBot](https://hoverbot.ai)
- [Get Started](https://sandbox.hoverbot.ai/get-started)
- [Blog](https://hoverbot.ai/blog)

## License

MIT
