# Renting Property — Housing

## Rental Search Checklist

### Before Viewing
- [ ] Budget defined (max 30% of gross income recommended)
- [ ] Credit report pulled (know what landlord will see)
- [ ] References ready (previous landlords, employer)
- [ ] Required documents gathered: ID, pay stubs, bank statements, tax returns

### During Viewing
- [ ] Water pressure tested (all faucets)
- [ ] Electrical outlets checked
- [ ] Windows/doors open/close properly
- [ ] Signs of pests (droppings, damage)
- [ ] Cell signal strength
- [ ] Noise levels (visit at different times)
- [ ] Storage space adequate
- [ ] Parking situation clear

### Lease Review (Critical Items)

| Clause | What to check |
|--------|--------------|
| Term length | Month-to-month vs fixed; penalties for early break |
| Rent increases | Notice period, caps if any |
| Security deposit | Amount, conditions for return, timeline |
| Utilities | What's included, what's separate |
| Maintenance | Who handles what; response time requirements |
| Subletting | Allowed? Under what conditions? |
| Pets | Fees, deposits, breed/size restrictions |
| Guests | Any restrictions on long-term guests |
| Modifications | Can you paint, hang shelves, etc.? |
| Renewal terms | Automatic? Notice required? |

## Tenant Rights (Varies by Jurisdiction)

Common protections to research locally:
- Habitability standards (heat, water, structural safety)
- Repair request timelines
- Entry notice requirements (typically 24-48 hours)
- Security deposit limits and return deadlines
- Rent control / stabilization (if applicable)
- Eviction process protections
- Discrimination protections

## Move-In Documentation

**Photograph everything** before moving in:
- All walls, floors, ceilings
- Appliances (open, close, run)
- Bathroom fixtures
- Windows, screens, blinds
- Exterior areas if included
- Pre-existing damage noted in writing, signed by landlord

This protects your security deposit.

## Cost Comparison Framework

| Cost | Ask/Calculate |
|------|--------------|
| Effective rent | Base rent + utilities + parking + fees |
| Move-in costs | First/last month + security deposit + application fees |
| Hidden costs | Laundry, storage unit, renter's insurance |
| Commute cost | Factor transport into total housing cost |

## Red Flags

- Landlord wants cash only / no receipt
- Pressure to sign immediately
- Reluctant to provide lease copy before signing
- Vague about repairs or maintenance responsibility
- No formal application process (may indicate tax evasion, no protections)
- Listing photos don't match property
