# Landlord Operations — Housing

## Tenant Screening Process

### Required Documentation
- Government ID
- Proof of income (3x rent recommended): pay stubs, tax returns, bank statements
- Employment verification (contact employer directly)
- Credit report (with tenant authorization)
- Background check (criminal, eviction history)
- Previous landlord references (call, don't just accept letters)

### Screening Criteria (Document Consistently)
| Factor | Typical threshold |
|--------|------------------|
| Income | 3x monthly rent gross |
| Credit score | 620+ (adjust by market) |
| Rental history | No evictions, positive references |
| Employment | Stable (6+ months) or verifiable alternative |

**Document your criteria** — apply same standards to all applicants to avoid discrimination claims.

## Lease Essentials

### Must-Include Clauses
- Parties, property address, lease term
- Rent amount, due date, late fee policy
- Security deposit amount and return conditions
- Maintenance responsibilities (who fixes what)
- Entry notice requirements
- Rules: pets, smoking, guests, noise, alterations
- Termination conditions and notice periods
- Lead paint disclosure (if applicable)

### Addendums to Consider
- Pet agreement (deposit, species, liability)
- Move-in/move-out inspection checklist
- Parking assignment
- HOA rules acknowledgment
- Bed bug protocol
- Mold disclosure

## Rent Pricing Strategy

### Market Analysis
- Check comparable units (size, amenities, location, condition)
- Monitor vacancy rates — high vacancy = lower rents
- Seasonal factors (summer typically stronger)
- Factor in unique features (parking, laundry, view)

### Pricing Approaches
| Goal | Strategy |
|------|----------|
| Minimize vacancy | Price at or slightly below market |
| Maximize rent | Premium pricing, accept longer vacancy |
| Retain good tenants | Below-market increases at renewal |

## Maintenance Framework

### Response Priorities
| Category | Timeline | Examples |
|----------|----------|----------|
| Emergency | Immediate | No heat (winter), flooding, gas leak, no water |
| Urgent | 24-48 hours | No hot water, broken lock, AC out (summer) |
| Routine | 3-7 days | Appliance issues, minor leaks, cosmetic |
| Scheduled | Next turnover | Painting, carpet replacement, upgrades |

### Preventive Maintenance Calendar
- Monthly: HVAC filter check, smoke detector test
- Quarterly: Inspect exterior, gutters, landscaping
- Annually: HVAC service, water heater flush, roof inspection
- As needed: Pest control, dryer vent cleaning

## Financial Tracking

### Income Records
- Rent payments (date, amount, method)
- Late fees collected
- Application fees
- Pet fees/rent

### Expense Records
- Mortgage payments (principal vs interest for taxes)
- Insurance premiums
- Property taxes
- Repairs and maintenance (save all receipts)
- Professional services (management, legal, accounting)
- Utilities paid by landlord
- Travel to property
- Depreciation schedule

## Tax Considerations

### Common Deductions
- Mortgage interest
- Property taxes
- Insurance
- Repairs (not improvements)
- Property management fees
- Professional services
- Travel to property
- Home office (if managing from home)

### Depreciation
Residential rental property: 27.5 years straight-line.
Building value only (not land) — get proper allocation.

### Record Retention
Keep all records minimum 7 years after sale of property.
