# Investment Analysis — Housing

## Key Metrics

### Cap Rate (Capitalization Rate)
```
Cap Rate = Net Operating Income / Purchase Price × 100

NOI = Gross Rental Income - Operating Expenses
Operating Expenses = Property tax + Insurance + Maintenance + Management + Vacancy allowance
```

| Cap Rate | Market interpretation |
|----------|----------------------|
| <4% | Premium market, appreciation play |
| 4-6% | Balanced market |
| 6-8% | Cash flow focused |
| >8% | Higher risk or emerging market |

### Cash-on-Cash Return
```
Cash-on-Cash = Annual Cash Flow / Total Cash Invested × 100

Annual Cash Flow = NOI - Debt Service (mortgage payments)
Total Cash Invested = Down payment + Closing costs + Rehab
```

Target: 8-12% for most investors.

### 1% Rule (Quick Filter)
Monthly rent should be ≥1% of purchase price for positive cash flow.

$200,000 property → should rent for ≥$2,000/month

Not a hard rule — adjust for market, property type, financing.

## Due Diligence Checklist

### Market Analysis
- [ ] Population growth trend (positive?)
- [ ] Employment diversity (not single-employer dependent)
- [ ] Rent growth history (3-5 years)
- [ ] Vacancy rates in area
- [ ] Comparable rents verified (not just listing prices)
- [ ] Future development plans (infrastructure, competitors)

### Property Analysis
- [ ] Actual rent rolls reviewed (not pro forma)
- [ ] Operating expense history (2-3 years)
- [ ] Capital expenditure history and upcoming needs
- [ ] Tenant quality and lease terms
- [ ] Physical inspection completed
- [ ] Environmental issues checked

### Financial Analysis
- [ ] Cash flow projections (conservative assumptions)
- [ ] Stress test: +2% rates, 2x vacancy, 10% rent drop
- [ ] Exit strategy defined (sell timeline, refi potential)
- [ ] Tax implications calculated (depreciation, 1031 exchange potential)

## Investment Strategies

| Strategy | Profile | Risk | Return Target |
|----------|---------|------|---------------|
| Buy and hold | Long-term, passive | Low-Medium | 8-15% total |
| BRRRR | Active, capital recycling | Medium | 15-25% |
| House hacking | Owner-occupant | Low | Reduced living cost |
| Short-term rental | Active management | Medium-High | 15-30% |
| Syndication | Passive investor | Variable | 12-20% |

## Common Mistakes

- **Using asking rent as actual** — verify with current tenant leases, market comps
- **Ignoring management cost** — even self-managed, value your time at 8-10% of rent
- **Underestimating CapEx** — roof, HVAC, water heater WILL need replacement
- **Over-leveraging** — negative cash flow kills during vacancies
- **Skipping tenant screening** — eviction costs $5-10k+ plus lost rent
- **Emotional attachment** — it's a business, not your home

## Exit Planning

Define before purchase:
- Minimum hold period (typically 5+ years for transaction cost recovery)
- Target equity multiple or IRR
- Market conditions that trigger sale
- 1031 exchange eligibility considerations
- Alternative: refinance and hold strategy
