# Buying Property — Housing

## Pre-Purchase Checklist

### Financial Readiness
- [ ] Credit score checked and optimized (6+ months before)
- [ ] Debt-to-income ratio calculated (<43% for most lenders)
- [ ] Down payment saved (typical: 10-20%, some programs accept 3-5%)
- [ ] Emergency fund separate from down payment (3-6 months expenses)
- [ ] Pre-approval letter obtained (not just pre-qualification)

### Search Criteria
- [ ] Must-haves vs nice-to-haves defined
- [ ] Location priorities: commute, schools, amenities
- [ ] Property type: house, condo, townhouse
- [ ] Budget includes ALL costs (see total cost calculation)

### Due Diligence
- [ ] Professional inspection (structural, electrical, plumbing, roof)
- [ ] Pest/termite inspection (critical in some regions)
- [ ] Title search completed
- [ ] HOA documents reviewed (if applicable)
- [ ] Flood zone / natural disaster risk checked
- [ ] Comparable sales analyzed (last 3-6 months, within 1km)

### Closing Preparation
- [ ] Final walk-through scheduled
- [ ] Closing costs funds ready (wire transfer, certified check)
- [ ] Insurance policy bound before closing
- [ ] Utilities transfer arranged
- [ ] Change of address filed

## Mortgage Types Comparison

| Type | Best for | Watch out |
|------|----------|-----------|
| Fixed-rate | Stability seekers, long-term hold | Higher initial rate |
| ARM (adjustable) | Short-term owners, rate-drop bettors | Payment shock risk |
| FHA (US) | Low down payment, lower credit | Mortgage insurance required |
| VA (US) | Veterans | Funding fee, property restrictions |
| Interest-only | Investors, high earners | Principal never decreases |

## Negotiation Levers

Beyond price:
- Closing cost credits
- Repair credits
- Closing date flexibility
- Appliance/furniture inclusion
- Home warranty inclusion
- Earnest money terms

## Red Flags During Inspection

| Issue | Severity | Action |
|-------|----------|--------|
| Foundation cracks | High | Structural engineer required |
| Active water damage | High | Renegotiate or walk |
| Roof age >20 years | Medium | Budget $10-30k replacement |
| Knob-and-tube wiring | Medium | Insurance may decline, rewire cost |
| Unpermitted additions | Medium | May affect resale, insurance |
| Mold presence | Variable | Remediation quote before proceeding |
