---
name: housing-scout
description: Find and monitor housing listings (buy/rent), apply practical filters, and manage subscription-style alerts in any supported region. Use when the user asks to search homes, compare candidates, run comps, or set listing notifications.
user-invocable: true
command-dispatch: tool
command-tool: exec
---

# Housing Scout

This skill is self-contained for ClawHub publish. All commands run against the bundled runtime under `./scripts/housing_scout/`.

## Quickstart (recommended)

- Create a profile and run first search immediately:
  - `node ./scripts/housing_scout/housing_scout.mjs quickstart --name "great nyc area" --city "New York" --state "NY" --beds-min 3 --budget-max 2000000 --run true`

## Direct search (no profile required)

- Buy:
  - `node ./scripts/housing_scout/housing_scout.mjs search --intent buy --city "Seattle" --state "WA" --beds-min 3 --budget-max 1200000`
- Rent:
  - `node ./scripts/housing_scout/housing_scout.mjs search --intent rent --city "Seattle" --state "WA" --beds-min 2 --budget-max 4500`

## Profile workflow

- Create:
  - `node ./scripts/housing_scout/housing_scout.mjs create_profile --name "great new york city area" --city "New York" --state "NY" --country "US" --beds-min 3 --budget-max 2000000`
- List:
  - `node ./scripts/housing_scout/housing_scout.mjs list_profiles`
- Show:
  - `node ./scripts/housing_scout/housing_scout.mjs show_profile --name "great new york city area"`
- Delete:
  - `node ./scripts/housing_scout/housing_scout.mjs delete_profile --name "great new york city area"`
- Use profile:
  - `node ./scripts/housing_scout/housing_scout.mjs search --profile "great new york city area" --intent buy`
  - `node ./scripts/housing_scout/housing_scout.mjs search --profile "great new york city area" --intent rent`

## Provider cache operations

- Status:
  - `node ./scripts/housing_scout/housing_scout.mjs provider_cache_status --provider zillow --intent buy`
- Refresh:
  - `node ./scripts/housing_scout/housing_scout.mjs refresh_provider_cache --provider zillow --intent buy --from /app/workspace/tmp/zillow_buy.json`

## Other useful commands

- Lease flow:
  - `node ./scripts/housing_scout/housing_scout.mjs lease --profile "great new york city area"`
- Comps from Redfin URL:
  - `node ./scripts/housing_scout/housing_scout.mjs comps --query south-bay-buy-default --redfin-url "https://www.redfin.com/..."`
- Subscriptions:
  - `node ./scripts/housing_scout/housing_scout.mjs subscribe --query south-bay-buy-default --channel telegram --to YOUR_CHAT_ID`
  - `node ./scripts/housing_scout/housing_scout.mjs list_subscriptions`
  - `node ./scripts/housing_scout/housing_scout.mjs run_subscriptions`

## Optional preset example

- The built-in South Bay preset is only for demo/smoke test:
  - `node ./scripts/housing_scout/housing_scout.mjs search --query south-bay-buy-default`

## Notes

- Multi-provider selector: `--providers redfin,zillow,realtor`.
- Provider status:
  - Redfin: live feed/caches
  - Zillow: live-cache adapter (`live_zillow_buy.json` / `live_zillow_rent.json`)
  - Realtor: live-cache adapter (`live_realtor_buy.json` / `live_realtor_rent.json`)
- `refresh_provider_cache` input shape:
  - `{ "listings": [ { "address"|"street/city/state/zip", "url", "price"|"rent", "beds", "baths", "sqft", "homeType" } ] }`

## Privacy/safety checklist

- Replace `YOUR_CHAT_ID` with your own target.
- Do not commit personal chat IDs, tokens, or private channels.
- Keep credentials outside skill files (env vars or gateway config).
