# Renting Out Your Property

## Before You Rent

**Financial reality check:**
- Rental income must cover: mortgage + taxes + insurance + maintenance + vacancy
- Budget 1-2 months vacancy per year
- Budget 10% of rent for repairs/maintenance
- Set aside 3-6 months expenses as reserve

**Legal requirements:**
- Landlord-tenant laws vary by state/city — know yours
- Required disclosures (lead paint, sex offenders, flood zone)
- Habitability standards (heat, water, safety)
- Security deposit limits and handling rules
- Eviction process and timeline

**Insurance:**
- Homeowner's insurance doesn't cover rentals
- Switch to landlord/rental property insurance
- Consider umbrella policy for liability
- Require renter's insurance from tenants

---

## Setting the Rent

**Market research:**
1. Check Zillow, Rentometer, Craigslist for comparables
2. Match: bedrooms, bathrooms, sqft, amenities, location
3. Adjust for condition and updates
4. Price at market or slightly below for faster placement

**Pricing factors:**
- Pet-friendly: +$25-100/month (plus deposit)
- In-unit laundry: +$50-100/month
- Parking: +$50-150/month (urban areas)
- Utilities included: +$100-200/month

**Vacancy costs more than lower rent:** A $1,500/month unit vacant for 2 months = $3,000 lost. Pricing $100 under market fills faster and costs $1,200/year — you're ahead.

---

## Finding Tenants

**Listing essentials:**
- Professional photos (natural light, wide angles)
- Accurate description (beds, baths, sqft, parking, laundry)
- Clear rent and deposit amounts
- Pet policy stated upfront
- Move-in date

**Where to list:**
- Zillow (free, high traffic)
- Apartments.com
- Facebook Marketplace
- Craigslist (screen carefully)
- Local property management groups

**Showing tips:**
- Schedule grouped showings (efficiency)
- Property must be clean and functional
- All lights on, temperature comfortable
- Have application forms ready

---

## Screening Tenants

**Application must include:**
- Full legal name and SSN
- Current and previous addresses
- Employment and income verification
- References (current landlord, employer)
- Authorization to run credit/background

**Screening checklist:**
- [ ] Credit score 650+ (lower = higher risk)
- [ ] Income 3x rent minimum
- [ ] Clean background check
- [ ] Positive landlord references
- [ ] Stable employment (2+ years or solid history)
- [ ] No prior evictions

**Red flags:**
- Pressuring for quick move-in
- Offering extra deposit to skip screening
- Can't provide employer contact
- Current landlord "unreachable"
- Gaps in rental history

**Fair Housing:** Cannot discriminate based on race, color, religion, sex, national origin, familial status, disability. Applies to advertising and screening.

---

## The Lease

**Must include:**
- Property address and description
- Tenant names (all adults on lease)
- Lease term (start/end dates)
- Rent amount and due date
- Late fee policy
- Security deposit amount and terms
- Pet policy
- Maintenance responsibilities
- Entry notice requirements
- Termination and renewal terms

**Addendums to consider:**
- Pet addendum (pet deposit, breed restrictions)
- Smoking policy
- Parking assignment
- Move-in/move-out checklist
- Rules and regulations

**Use state-specific templates** — generic leases miss required clauses.

---

## Collecting Rent

**Methods (best to worst):**
1. ACH/bank transfer (automatic, free)
2. Online platforms (Cozy, Avail, Buildium)
3. Check (creates paper trail)
4. Cash (avoid — no proof)

**Late rent process:**
1. Grace period (typically 3-5 days)
2. Late fee kicks in (usually 5-10% of rent)
3. Pay or quit notice (3-day in most states)
4. Eviction filing if no payment

**Document everything:** Date, amount, method. Keep records 7+ years.

---

## Maintenance

**Landlord responsibilities:**
- Structural integrity
- Plumbing, heating, electrical
- Hot and cold water
- Smoke/CO detectors
- Pest control (varies by state)
- Common area maintenance

**Tenant responsibilities:**
- Keep property clean
- Report issues promptly
- Minor upkeep (light bulbs, filters)
- Damage they cause

**Response timeline:**
- Emergency (no heat, flood, gas): Immediate
- Urgent (no hot water, broken lock): 24-48 hours
- Routine (dripping faucet, stuck door): 7-14 days

**Build a vendor list:** Plumber, electrician, HVAC, handyman, cleaner. Vet them before you need them urgently.

---

## Self-Manage vs Property Manager

**Self-manage if:**
- Property nearby
- Few units (1-3)
- You're handy and available
- You can handle tenant issues
- Savings: 8-12% of rent

**Hire property manager if:**
- Property far away
- Multiple units or scaling
- You value your time highly
- Don't want tenant calls
- Cost: 8-12% of rent + placement fee

**What PM handles:**
- Marketing and showings
- Screening and lease signing
- Rent collection
- Maintenance coordination
- Evictions

---

## Problem Tenants

**Late payers:**
1. Call day after due date (friendly reminder)
2. Send written notice at grace period end
3. Pay or quit notice if still unpaid
4. Start eviction if notice period passes

**Lease violations:**
1. Document the violation (photos, dates)
2. Send cure or quit notice
3. Allow cure period
4. Eviction if not cured

**Eviction process:**
1. Proper notice served
2. Court filing
3. Hearing
4. Judgment
5. Writ of possession
6. Sheriff lockout

**Timeline:** 3-12 weeks depending on state and tenant response. Never "self-help" eviction (changing locks, shutting utilities).

---

## Turnover

**Move-out process:**
1. Give/receive proper notice (usually 30-60 days)
2. Schedule move-out inspection
3. Walk through with tenant, document condition
4. Return deposit minus legitimate deductions
5. Send itemized statement within deadline (varies by state)

**Legitimate deductions:**
- Unpaid rent
- Damage beyond normal wear and tear
- Cleaning if left dirty
- Unreturned keys

**Normal wear (not deductible):**
- Faded paint
- Worn carpet in traffic areas
- Minor scuffs and nail holes
- Appliance aging

**Between tenants:**
- Deep clean
- Paint if needed
- Replace worn items
- Update photos for listing
- Address deferred maintenance
